/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacePermissionsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeNetworkInterfacePermissionsRequestMarshaller
implements Marshaller<Request<DescribeNetworkInterfacePermissionsRequest>, DescribeNetworkInterfacePermissionsRequest> {
    public Request<DescribeNetworkInterfacePermissionsRequest> marshall(DescribeNetworkInterfacePermissionsRequest describeNetworkInterfacePermissionsRequest) {
        List<Filter> describeNetworkInterfacePermissionsRequestFiltersList;
        if (describeNetworkInterfacePermissionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeNetworkInterfacePermissionsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeNetworkInterfacePermissions");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeNetworkInterfacePermissionsRequestNetworkInterfacePermissionIdsList = describeNetworkInterfacePermissionsRequest.networkInterfacePermissionIds();
        if (!describeNetworkInterfacePermissionsRequestNetworkInterfacePermissionIdsList.isEmpty() || !(describeNetworkInterfacePermissionsRequestNetworkInterfacePermissionIdsList instanceof SdkAutoConstructList)) {
            int networkInterfacePermissionIdsListIndex = 1;
            for (String describeNetworkInterfacePermissionsRequestNetworkInterfacePermissionIdsListValue : describeNetworkInterfacePermissionsRequestNetworkInterfacePermissionIdsList) {
                if (describeNetworkInterfacePermissionsRequestNetworkInterfacePermissionIdsListValue != null) {
                    request.addParameter("NetworkInterfacePermissionId." + networkInterfacePermissionIdsListIndex, StringConversion.fromString((String)describeNetworkInterfacePermissionsRequestNetworkInterfacePermissionIdsListValue));
                }
                ++networkInterfacePermissionIdsListIndex;
            }
        }
        if (!(describeNetworkInterfacePermissionsRequestFiltersList = describeNetworkInterfacePermissionsRequest.filters()).isEmpty() || !(describeNetworkInterfacePermissionsRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeNetworkInterfacePermissionsRequestFiltersListValue : describeNetworkInterfacePermissionsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeNetworkInterfacePermissionsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeNetworkInterfacePermissionsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeNetworkInterfacePermissionsRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeNetworkInterfacePermissionsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeNetworkInterfacePermissionsRequest.nextToken()));
        }
        if (describeNetworkInterfacePermissionsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeNetworkInterfacePermissionsRequest.maxResults()));
        }
        return request;
    }
}

