/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeKeyPairsRequestMarshaller
implements Marshaller<Request<DescribeKeyPairsRequest>, DescribeKeyPairsRequest> {
    public Request<DescribeKeyPairsRequest> marshall(DescribeKeyPairsRequest describeKeyPairsRequest) {
        List<String> describeKeyPairsRequestKeyNamesList;
        if (describeKeyPairsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeKeyPairsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeKeyPairs");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeKeyPairsRequestFiltersList = describeKeyPairsRequest.filters();
        if (!describeKeyPairsRequestFiltersList.isEmpty() || !(describeKeyPairsRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeKeyPairsRequestFiltersListValue : describeKeyPairsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeKeyPairsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeKeyPairsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeKeyPairsRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeKeyPairsRequestKeyNamesList = describeKeyPairsRequest.keyNames()).isEmpty() || !(describeKeyPairsRequestKeyNamesList instanceof SdkAutoConstructList)) {
            int keyNamesListIndex = 1;
            for (String describeKeyPairsRequestKeyNamesListValue : describeKeyPairsRequestKeyNamesList) {
                if (describeKeyPairsRequestKeyNamesListValue != null) {
                    request.addParameter("KeyName." + keyNamesListIndex, StringConversion.fromString((String)describeKeyPairsRequestKeyNamesListValue));
                }
                ++keyNamesListIndex;
            }
        }
        return request;
    }
}

