/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceCreditSpecificationsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeInstanceCreditSpecificationsRequestMarshaller
implements Marshaller<Request<DescribeInstanceCreditSpecificationsRequest>, DescribeInstanceCreditSpecificationsRequest> {
    public Request<DescribeInstanceCreditSpecificationsRequest> marshall(DescribeInstanceCreditSpecificationsRequest describeInstanceCreditSpecificationsRequest) {
        List<String> describeInstanceCreditSpecificationsRequestInstanceIdsList;
        if (describeInstanceCreditSpecificationsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeInstanceCreditSpecificationsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeInstanceCreditSpecifications");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeInstanceCreditSpecificationsRequestFiltersList = describeInstanceCreditSpecificationsRequest.filters();
        if (!describeInstanceCreditSpecificationsRequestFiltersList.isEmpty() || !(describeInstanceCreditSpecificationsRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeInstanceCreditSpecificationsRequestFiltersListValue : describeInstanceCreditSpecificationsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeInstanceCreditSpecificationsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeInstanceCreditSpecificationsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeInstanceCreditSpecificationsRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeInstanceCreditSpecificationsRequestInstanceIdsList = describeInstanceCreditSpecificationsRequest.instanceIds()).isEmpty() || !(describeInstanceCreditSpecificationsRequestInstanceIdsList instanceof SdkAutoConstructList)) {
            int instanceIdsListIndex = 1;
            for (String describeInstanceCreditSpecificationsRequestInstanceIdsListValue : describeInstanceCreditSpecificationsRequestInstanceIdsList) {
                if (describeInstanceCreditSpecificationsRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringConversion.fromString((String)describeInstanceCreditSpecificationsRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (describeInstanceCreditSpecificationsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeInstanceCreditSpecificationsRequest.maxResults()));
        }
        if (describeInstanceCreditSpecificationsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeInstanceCreditSpecificationsRequest.nextToken()));
        }
        return request;
    }
}

