/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeImportSnapshotTasksRequestMarshaller
implements Marshaller<Request<DescribeImportSnapshotTasksRequest>, DescribeImportSnapshotTasksRequest> {
    public Request<DescribeImportSnapshotTasksRequest> marshall(DescribeImportSnapshotTasksRequest describeImportSnapshotTasksRequest) {
        List<String> describeImportSnapshotTasksRequestImportTaskIdsList;
        if (describeImportSnapshotTasksRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeImportSnapshotTasksRequest, "Ec2Client");
        request.addParameter("Action", "DescribeImportSnapshotTasks");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeImportSnapshotTasksRequestFiltersList = describeImportSnapshotTasksRequest.filters();
        if (!describeImportSnapshotTasksRequestFiltersList.isEmpty() || !(describeImportSnapshotTasksRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeImportSnapshotTasksRequestFiltersListValue : describeImportSnapshotTasksRequestFiltersList) {
                List<String> filterValuesList;
                if (describeImportSnapshotTasksRequestFiltersListValue.name() != null) {
                    request.addParameter("Filters." + filtersListIndex + ".Name", StringConversion.fromString((String)describeImportSnapshotTasksRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeImportSnapshotTasksRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filters." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeImportSnapshotTasksRequestImportTaskIdsList = describeImportSnapshotTasksRequest.importTaskIds()).isEmpty() || !(describeImportSnapshotTasksRequestImportTaskIdsList instanceof SdkAutoConstructList)) {
            int importTaskIdsListIndex = 1;
            for (String describeImportSnapshotTasksRequestImportTaskIdsListValue : describeImportSnapshotTasksRequestImportTaskIdsList) {
                if (describeImportSnapshotTasksRequestImportTaskIdsListValue != null) {
                    request.addParameter("ImportTaskId." + importTaskIdsListIndex, StringConversion.fromString((String)describeImportSnapshotTasksRequestImportTaskIdsListValue));
                }
                ++importTaskIdsListIndex;
            }
        }
        if (describeImportSnapshotTasksRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeImportSnapshotTasksRequest.maxResults()));
        }
        if (describeImportSnapshotTasksRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeImportSnapshotTasksRequest.nextToken()));
        }
        return request;
    }
}

