/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeHostsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeHostsRequestMarshaller
implements Marshaller<Request<DescribeHostsRequest>, DescribeHostsRequest> {
    public Request<DescribeHostsRequest> marshall(DescribeHostsRequest describeHostsRequest) {
        List<String> describeHostsRequestHostIdsList;
        if (describeHostsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeHostsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeHosts");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeHostsRequestFilterList = describeHostsRequest.filter();
        if (!describeHostsRequestFilterList.isEmpty() || !(describeHostsRequestFilterList instanceof SdkAutoConstructList)) {
            int filterListIndex = 1;
            for (Filter describeHostsRequestFilterListValue : describeHostsRequestFilterList) {
                List<String> filterValuesList;
                if (describeHostsRequestFilterListValue.name() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name", StringConversion.fromString((String)describeHostsRequestFilterListValue.name()));
                }
                if (!(filterValuesList = describeHostsRequestFilterListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filterListIndex;
            }
        }
        if (!(describeHostsRequestHostIdsList = describeHostsRequest.hostIds()).isEmpty() || !(describeHostsRequestHostIdsList instanceof SdkAutoConstructList)) {
            int hostIdsListIndex = 1;
            for (String describeHostsRequestHostIdsListValue : describeHostsRequestHostIdsList) {
                if (describeHostsRequestHostIdsListValue != null) {
                    request.addParameter("HostId." + hostIdsListIndex, StringConversion.fromString((String)describeHostsRequestHostIdsListValue));
                }
                ++hostIdsListIndex;
            }
        }
        if (describeHostsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeHostsRequest.maxResults()));
        }
        if (describeHostsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeHostsRequest.nextToken()));
        }
        return request;
    }
}

