/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeHostReservationsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeHostReservationsRequestMarshaller
implements Marshaller<Request<DescribeHostReservationsRequest>, DescribeHostReservationsRequest> {
    public Request<DescribeHostReservationsRequest> marshall(DescribeHostReservationsRequest describeHostReservationsRequest) {
        List<String> describeHostReservationsRequestHostReservationIdSetList;
        if (describeHostReservationsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeHostReservationsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeHostReservations");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeHostReservationsRequestFilterList = describeHostReservationsRequest.filter();
        if (!describeHostReservationsRequestFilterList.isEmpty() || !(describeHostReservationsRequestFilterList instanceof SdkAutoConstructList)) {
            int filterListIndex = 1;
            for (Filter describeHostReservationsRequestFilterListValue : describeHostReservationsRequestFilterList) {
                List<String> filterValuesList;
                if (describeHostReservationsRequestFilterListValue.name() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name", StringConversion.fromString((String)describeHostReservationsRequestFilterListValue.name()));
                }
                if (!(filterValuesList = describeHostReservationsRequestFilterListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filterListIndex;
            }
        }
        if (!(describeHostReservationsRequestHostReservationIdSetList = describeHostReservationsRequest.hostReservationIdSet()).isEmpty() || !(describeHostReservationsRequestHostReservationIdSetList instanceof SdkAutoConstructList)) {
            int hostReservationIdSetListIndex = 1;
            for (String describeHostReservationsRequestHostReservationIdSetListValue : describeHostReservationsRequestHostReservationIdSetList) {
                if (describeHostReservationsRequestHostReservationIdSetListValue != null) {
                    request.addParameter("HostReservationIdSet." + hostReservationIdSetListIndex, StringConversion.fromString((String)describeHostReservationsRequestHostReservationIdSetListValue));
                }
                ++hostReservationIdSetListIndex;
            }
        }
        if (describeHostReservationsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeHostReservationsRequest.maxResults()));
        }
        if (describeHostReservationsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeHostReservationsRequest.nextToken()));
        }
        return request;
    }
}

