/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.time.Instant;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeFleetHistoryRequest;

public class DescribeFleetHistoryRequestMarshaller
implements Marshaller<Request<DescribeFleetHistoryRequest>, DescribeFleetHistoryRequest> {
    public Request<DescribeFleetHistoryRequest> marshall(DescribeFleetHistoryRequest describeFleetHistoryRequest) {
        if (describeFleetHistoryRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeFleetHistoryRequest, "Ec2Client");
        request.addParameter("Action", "DescribeFleetHistory");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeFleetHistoryRequest.eventTypeAsString() != null) {
            request.addParameter("EventType", StringConversion.fromString((String)describeFleetHistoryRequest.eventTypeAsString()));
        }
        if (describeFleetHistoryRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeFleetHistoryRequest.maxResults()));
        }
        if (describeFleetHistoryRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeFleetHistoryRequest.nextToken()));
        }
        if (describeFleetHistoryRequest.fleetId() != null) {
            request.addParameter("FleetId", StringConversion.fromString((String)describeFleetHistoryRequest.fleetId()));
        }
        if (describeFleetHistoryRequest.startTime() != null) {
            request.addParameter("StartTime", StringConversion.fromInstant((Instant)describeFleetHistoryRequest.startTime()));
        }
        return request;
    }
}

