/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeDhcpOptionsRequestMarshaller
implements Marshaller<Request<DescribeDhcpOptionsRequest>, DescribeDhcpOptionsRequest> {
    public Request<DescribeDhcpOptionsRequest> marshall(DescribeDhcpOptionsRequest describeDhcpOptionsRequest) {
        List<Filter> describeDhcpOptionsRequestFiltersList;
        if (describeDhcpOptionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeDhcpOptionsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeDhcpOptions");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeDhcpOptionsRequestDhcpOptionsIdsList = describeDhcpOptionsRequest.dhcpOptionsIds();
        if (!describeDhcpOptionsRequestDhcpOptionsIdsList.isEmpty() || !(describeDhcpOptionsRequestDhcpOptionsIdsList instanceof SdkAutoConstructList)) {
            int dhcpOptionsIdsListIndex = 1;
            for (String describeDhcpOptionsRequestDhcpOptionsIdsListValue : describeDhcpOptionsRequestDhcpOptionsIdsList) {
                if (describeDhcpOptionsRequestDhcpOptionsIdsListValue != null) {
                    request.addParameter("DhcpOptionsId." + dhcpOptionsIdsListIndex, StringConversion.fromString((String)describeDhcpOptionsRequestDhcpOptionsIdsListValue));
                }
                ++dhcpOptionsIdsListIndex;
            }
        }
        if (!(describeDhcpOptionsRequestFiltersList = describeDhcpOptionsRequest.filters()).isEmpty() || !(describeDhcpOptionsRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeDhcpOptionsRequestFiltersListValue : describeDhcpOptionsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeDhcpOptionsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeDhcpOptionsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeDhcpOptionsRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

