/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointsRequest;

public class DeleteVpcEndpointsRequestMarshaller
implements Marshaller<Request<DeleteVpcEndpointsRequest>, DeleteVpcEndpointsRequest> {
    public Request<DeleteVpcEndpointsRequest> marshall(DeleteVpcEndpointsRequest deleteVpcEndpointsRequest) {
        if (deleteVpcEndpointsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteVpcEndpointsRequest, "Ec2Client");
        request.addParameter("Action", "DeleteVpcEndpoints");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> deleteVpcEndpointsRequestVpcEndpointIdsList = deleteVpcEndpointsRequest.vpcEndpointIds();
        if (!deleteVpcEndpointsRequestVpcEndpointIdsList.isEmpty() || !(deleteVpcEndpointsRequestVpcEndpointIdsList instanceof SdkAutoConstructList)) {
            int vpcEndpointIdsListIndex = 1;
            for (String deleteVpcEndpointsRequestVpcEndpointIdsListValue : deleteVpcEndpointsRequestVpcEndpointIdsList) {
                if (deleteVpcEndpointsRequestVpcEndpointIdsListValue != null) {
                    request.addParameter("VpcEndpointId." + vpcEndpointIdsListIndex, StringConversion.fromString((String)deleteVpcEndpointsRequestVpcEndpointIdsListValue));
                }
                ++vpcEndpointIdsListIndex;
            }
        }
        return request;
    }
}

