/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DeleteTagsRequest;
import software.amazon.awssdk.services.ec2.model.Tag;

public class DeleteTagsRequestMarshaller
implements Marshaller<Request<DeleteTagsRequest>, DeleteTagsRequest> {
    public Request<DeleteTagsRequest> marshall(DeleteTagsRequest deleteTagsRequest) {
        List<Tag> deleteTagsRequestTagsList;
        if (deleteTagsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteTagsRequest, "Ec2Client");
        request.addParameter("Action", "DeleteTags");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> deleteTagsRequestResourcesList = deleteTagsRequest.resources();
        if (!deleteTagsRequestResourcesList.isEmpty() || !(deleteTagsRequestResourcesList instanceof SdkAutoConstructList)) {
            int resourcesListIndex = 1;
            for (String deleteTagsRequestResourcesListValue : deleteTagsRequestResourcesList) {
                if (deleteTagsRequestResourcesListValue != null) {
                    request.addParameter("ResourceId." + resourcesListIndex, StringConversion.fromString((String)deleteTagsRequestResourcesListValue));
                }
                ++resourcesListIndex;
            }
        }
        if (!(deleteTagsRequestTagsList = deleteTagsRequest.tags()).isEmpty() || !(deleteTagsRequestTagsList instanceof SdkAutoConstructList)) {
            int tagsListIndex = 1;
            for (Tag deleteTagsRequestTagsListValue : deleteTagsRequestTagsList) {
                if (deleteTagsRequestTagsListValue.key() != null) {
                    request.addParameter("Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)deleteTagsRequestTagsListValue.key()));
                }
                if (deleteTagsRequestTagsListValue.value() != null) {
                    request.addParameter("Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)deleteTagsRequestTagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

