/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsRequest;

public class DeleteLaunchTemplateVersionsRequestMarshaller
implements Marshaller<Request<DeleteLaunchTemplateVersionsRequest>, DeleteLaunchTemplateVersionsRequest> {
    public Request<DeleteLaunchTemplateVersionsRequest> marshall(DeleteLaunchTemplateVersionsRequest deleteLaunchTemplateVersionsRequest) {
        List<String> deleteLaunchTemplateVersionsRequestVersionsList;
        if (deleteLaunchTemplateVersionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteLaunchTemplateVersionsRequest, "Ec2Client");
        request.addParameter("Action", "DeleteLaunchTemplateVersions");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteLaunchTemplateVersionsRequest.launchTemplateId() != null) {
            request.addParameter("LaunchTemplateId", StringConversion.fromString((String)deleteLaunchTemplateVersionsRequest.launchTemplateId()));
        }
        if (deleteLaunchTemplateVersionsRequest.launchTemplateName() != null) {
            request.addParameter("LaunchTemplateName", StringConversion.fromString((String)deleteLaunchTemplateVersionsRequest.launchTemplateName()));
        }
        if (!(deleteLaunchTemplateVersionsRequestVersionsList = deleteLaunchTemplateVersionsRequest.versions()).isEmpty() || !(deleteLaunchTemplateVersionsRequestVersionsList instanceof SdkAutoConstructList)) {
            int versionsListIndex = 1;
            for (String deleteLaunchTemplateVersionsRequestVersionsListValue : deleteLaunchTemplateVersionsRequestVersionsList) {
                if (deleteLaunchTemplateVersionsRequestVersionsListValue != null) {
                    request.addParameter("LaunchTemplateVersion." + versionsListIndex, StringConversion.fromString((String)deleteLaunchTemplateVersionsRequestVersionsListValue));
                }
                ++versionsListIndex;
            }
        }
        return request;
    }
}

