/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CreateVpcEndpointServiceConfigurationRequest;

public class CreateVpcEndpointServiceConfigurationRequestMarshaller
implements Marshaller<Request<CreateVpcEndpointServiceConfigurationRequest>, CreateVpcEndpointServiceConfigurationRequest> {
    public Request<CreateVpcEndpointServiceConfigurationRequest> marshall(CreateVpcEndpointServiceConfigurationRequest createVpcEndpointServiceConfigurationRequest) {
        List<String> createVpcEndpointServiceConfigurationRequestNetworkLoadBalancerArnsList;
        if (createVpcEndpointServiceConfigurationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createVpcEndpointServiceConfigurationRequest, "Ec2Client");
        request.addParameter("Action", "CreateVpcEndpointServiceConfiguration");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVpcEndpointServiceConfigurationRequest.acceptanceRequired() != null) {
            request.addParameter("AcceptanceRequired", StringConversion.fromBoolean((Boolean)createVpcEndpointServiceConfigurationRequest.acceptanceRequired()));
        }
        if (!(createVpcEndpointServiceConfigurationRequestNetworkLoadBalancerArnsList = createVpcEndpointServiceConfigurationRequest.networkLoadBalancerArns()).isEmpty() || !(createVpcEndpointServiceConfigurationRequestNetworkLoadBalancerArnsList instanceof SdkAutoConstructList)) {
            int networkLoadBalancerArnsListIndex = 1;
            for (String createVpcEndpointServiceConfigurationRequestNetworkLoadBalancerArnsListValue : createVpcEndpointServiceConfigurationRequestNetworkLoadBalancerArnsList) {
                if (createVpcEndpointServiceConfigurationRequestNetworkLoadBalancerArnsListValue != null) {
                    request.addParameter("NetworkLoadBalancerArn." + networkLoadBalancerArnsListIndex, StringConversion.fromString((String)createVpcEndpointServiceConfigurationRequestNetworkLoadBalancerArnsListValue));
                }
                ++networkLoadBalancerArnsListIndex;
            }
        }
        if (createVpcEndpointServiceConfigurationRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringConversion.fromString((String)createVpcEndpointServiceConfigurationRequest.clientToken()));
        }
        return request;
    }
}

