/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CreateSecurityGroupRequest;

public class CreateSecurityGroupRequestMarshaller
implements Marshaller<Request<CreateSecurityGroupRequest>, CreateSecurityGroupRequest> {
    public Request<CreateSecurityGroupRequest> marshall(CreateSecurityGroupRequest createSecurityGroupRequest) {
        if (createSecurityGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createSecurityGroupRequest, "Ec2Client");
        request.addParameter("Action", "CreateSecurityGroup");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createSecurityGroupRequest.description() != null) {
            request.addParameter("GroupDescription", StringConversion.fromString((String)createSecurityGroupRequest.description()));
        }
        if (createSecurityGroupRequest.groupName() != null) {
            request.addParameter("GroupName", StringConversion.fromString((String)createSecurityGroupRequest.groupName()));
        }
        if (createSecurityGroupRequest.vpcId() != null) {
            request.addParameter("VpcId", StringConversion.fromString((String)createSecurityGroupRequest.vpcId()));
        }
        return request;
    }
}

