/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.CreateFpgaImageRequest;
import software.amazon.awssdk.services.ec2.model.StorageLocation;

public class CreateFpgaImageRequestMarshaller
implements Marshaller<Request<CreateFpgaImageRequest>, CreateFpgaImageRequest> {
    public Request<CreateFpgaImageRequest> marshall(CreateFpgaImageRequest createFpgaImageRequest) {
        StorageLocation logsStorageLocation;
        if (createFpgaImageRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createFpgaImageRequest, "Ec2Client");
        request.addParameter("Action", "CreateFpgaImage");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        StorageLocation inputStorageLocation = createFpgaImageRequest.inputStorageLocation();
        if (inputStorageLocation != null) {
            if (inputStorageLocation.bucket() != null) {
                request.addParameter("InputStorageLocation.Bucket", StringConversion.fromString((String)inputStorageLocation.bucket()));
            }
            if (inputStorageLocation.key() != null) {
                request.addParameter("InputStorageLocation.Key", StringConversion.fromString((String)inputStorageLocation.key()));
            }
        }
        if ((logsStorageLocation = createFpgaImageRequest.logsStorageLocation()) != null) {
            if (logsStorageLocation.bucket() != null) {
                request.addParameter("LogsStorageLocation.Bucket", StringConversion.fromString((String)logsStorageLocation.bucket()));
            }
            if (logsStorageLocation.key() != null) {
                request.addParameter("LogsStorageLocation.Key", StringConversion.fromString((String)logsStorageLocation.key()));
            }
        }
        if (createFpgaImageRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)createFpgaImageRequest.description()));
        }
        if (createFpgaImageRequest.name() != null) {
            request.addParameter("Name", StringConversion.fromString((String)createFpgaImageRequest.name()));
        }
        if (createFpgaImageRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringConversion.fromString((String)createFpgaImageRequest.clientToken()));
        }
        return request;
    }
}

