/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.AttachInternetGatewayRequest;

public class AttachInternetGatewayRequestMarshaller
implements Marshaller<Request<AttachInternetGatewayRequest>, AttachInternetGatewayRequest> {
    public Request<AttachInternetGatewayRequest> marshall(AttachInternetGatewayRequest attachInternetGatewayRequest) {
        if (attachInternetGatewayRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)attachInternetGatewayRequest, "Ec2Client");
        request.addParameter("Action", "AttachInternetGateway");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (attachInternetGatewayRequest.internetGatewayId() != null) {
            request.addParameter("InternetGatewayId", StringConversion.fromString((String)attachInternetGatewayRequest.internetGatewayId()));
        }
        if (attachInternetGatewayRequest.vpcId() != null) {
            request.addParameter("VpcId", StringConversion.fromString((String)attachInternetGatewayRequest.vpcId()));
        }
        return request;
    }
}

