/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.AssignPrivateIpAddressesRequest;

public class AssignPrivateIpAddressesRequestMarshaller
implements Marshaller<Request<AssignPrivateIpAddressesRequest>, AssignPrivateIpAddressesRequest> {
    public Request<AssignPrivateIpAddressesRequest> marshall(AssignPrivateIpAddressesRequest assignPrivateIpAddressesRequest) {
        List<String> assignPrivateIpAddressesRequestPrivateIpAddressesList;
        if (assignPrivateIpAddressesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)assignPrivateIpAddressesRequest, "Ec2Client");
        request.addParameter("Action", "AssignPrivateIpAddresses");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (assignPrivateIpAddressesRequest.allowReassignment() != null) {
            request.addParameter("AllowReassignment", StringConversion.fromBoolean((Boolean)assignPrivateIpAddressesRequest.allowReassignment()));
        }
        if (assignPrivateIpAddressesRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringConversion.fromString((String)assignPrivateIpAddressesRequest.networkInterfaceId()));
        }
        if (!(assignPrivateIpAddressesRequestPrivateIpAddressesList = assignPrivateIpAddressesRequest.privateIpAddresses()).isEmpty() || !(assignPrivateIpAddressesRequestPrivateIpAddressesList instanceof SdkAutoConstructList)) {
            int privateIpAddressesListIndex = 1;
            for (String assignPrivateIpAddressesRequestPrivateIpAddressesListValue : assignPrivateIpAddressesRequestPrivateIpAddressesList) {
                if (assignPrivateIpAddressesRequestPrivateIpAddressesListValue != null) {
                    request.addParameter("PrivateIpAddress." + privateIpAddressesListIndex, StringConversion.fromString((String)assignPrivateIpAddressesRequestPrivateIpAddressesListValue));
                }
                ++privateIpAddressesListIndex;
            }
        }
        if (assignPrivateIpAddressesRequest.secondaryPrivateIpAddressCount() != null) {
            request.addParameter("SecondaryPrivateIpAddressCount", StringConversion.fromInteger((Integer)assignPrivateIpAddressesRequest.secondaryPrivateIpAddressCount()));
        }
        return request;
    }
}

