/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.AcceptVpcEndpointConnectionsRequest;

public class AcceptVpcEndpointConnectionsRequestMarshaller
implements Marshaller<Request<AcceptVpcEndpointConnectionsRequest>, AcceptVpcEndpointConnectionsRequest> {
    public Request<AcceptVpcEndpointConnectionsRequest> marshall(AcceptVpcEndpointConnectionsRequest acceptVpcEndpointConnectionsRequest) {
        List<String> acceptVpcEndpointConnectionsRequestVpcEndpointIdsList;
        if (acceptVpcEndpointConnectionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)acceptVpcEndpointConnectionsRequest, "Ec2Client");
        request.addParameter("Action", "AcceptVpcEndpointConnections");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (acceptVpcEndpointConnectionsRequest.serviceId() != null) {
            request.addParameter("ServiceId", StringConversion.fromString((String)acceptVpcEndpointConnectionsRequest.serviceId()));
        }
        if (!(acceptVpcEndpointConnectionsRequestVpcEndpointIdsList = acceptVpcEndpointConnectionsRequest.vpcEndpointIds()).isEmpty() || !(acceptVpcEndpointConnectionsRequestVpcEndpointIdsList instanceof SdkAutoConstructList)) {
            int vpcEndpointIdsListIndex = 1;
            for (String acceptVpcEndpointConnectionsRequestVpcEndpointIdsListValue : acceptVpcEndpointConnectionsRequestVpcEndpointIdsList) {
                if (acceptVpcEndpointConnectionsRequestVpcEndpointIdsListValue != null) {
                    request.addParameter("VpcEndpointId." + vpcEndpointIdsListIndex, StringConversion.fromString((String)acceptVpcEndpointConnectionsRequestVpcEndpointIdsListValue));
                }
                ++vpcEndpointIdsListIndex;
            }
        }
        return request;
    }
}

