/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CidrBlock;
import software.amazon.awssdk.services.ec2.model.CidrBlockSetCopier;
import software.amazon.awssdk.services.ec2.model.Ipv6CidrBlock;
import software.amazon.awssdk.services.ec2.model.Ipv6CidrBlockSetCopier;
import software.amazon.awssdk.services.ec2.model.VpcPeeringConnectionOptionsDescription;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcPeeringConnectionVpcInfo
implements ToCopyableBuilder<Builder, VpcPeeringConnectionVpcInfo> {
    private final String cidrBlock;
    private final List<Ipv6CidrBlock> ipv6CidrBlockSet;
    private final List<CidrBlock> cidrBlockSet;
    private final String ownerId;
    private final VpcPeeringConnectionOptionsDescription peeringOptions;
    private final String vpcId;
    private final String region;

    private VpcPeeringConnectionVpcInfo(BuilderImpl builder) {
        this.cidrBlock = builder.cidrBlock;
        this.ipv6CidrBlockSet = builder.ipv6CidrBlockSet;
        this.cidrBlockSet = builder.cidrBlockSet;
        this.ownerId = builder.ownerId;
        this.peeringOptions = builder.peeringOptions;
        this.vpcId = builder.vpcId;
        this.region = builder.region;
    }

    public String cidrBlock() {
        return this.cidrBlock;
    }

    public List<Ipv6CidrBlock> ipv6CidrBlockSet() {
        return this.ipv6CidrBlockSet;
    }

    public List<CidrBlock> cidrBlockSet() {
        return this.cidrBlockSet;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public VpcPeeringConnectionOptionsDescription peeringOptions() {
        return this.peeringOptions;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String region() {
        return this.region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6CidrBlockSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlockSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peeringOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcPeeringConnectionVpcInfo)) {
            return false;
        }
        VpcPeeringConnectionVpcInfo other = (VpcPeeringConnectionVpcInfo)obj;
        return Objects.equals(this.cidrBlock(), other.cidrBlock()) && Objects.equals(this.ipv6CidrBlockSet(), other.ipv6CidrBlockSet()) && Objects.equals(this.cidrBlockSet(), other.cidrBlockSet()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.peeringOptions(), other.peeringOptions()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.region(), other.region());
    }

    public String toString() {
        return ToString.builder((String)"VpcPeeringConnectionVpcInfo").add("CidrBlock", (Object)this.cidrBlock()).add("Ipv6CidrBlockSet", this.ipv6CidrBlockSet()).add("CidrBlockSet", this.cidrBlockSet()).add("OwnerId", (Object)this.ownerId()).add("PeeringOptions", (Object)this.peeringOptions()).add("VpcId", (Object)this.vpcId()).add("Region", (Object)this.region()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.cidrBlock()));
            }
            case "Ipv6CidrBlockSet": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrBlockSet()));
            }
            case "CidrBlockSet": {
                return Optional.ofNullable(clazz.cast(this.cidrBlockSet()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "PeeringOptions": {
                return Optional.ofNullable(clazz.cast(this.peeringOptions()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String cidrBlock;
        private List<Ipv6CidrBlock> ipv6CidrBlockSet = DefaultSdkAutoConstructList.getInstance();
        private List<CidrBlock> cidrBlockSet = DefaultSdkAutoConstructList.getInstance();
        private String ownerId;
        private VpcPeeringConnectionOptionsDescription peeringOptions;
        private String vpcId;
        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcPeeringConnectionVpcInfo model) {
            this.cidrBlock(model.cidrBlock);
            this.ipv6CidrBlockSet(model.ipv6CidrBlockSet);
            this.cidrBlockSet(model.cidrBlockSet);
            this.ownerId(model.ownerId);
            this.peeringOptions(model.peeringOptions);
            this.vpcId(model.vpcId);
            this.region(model.region);
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final Collection<Ipv6CidrBlock.Builder> getIpv6CidrBlockSet() {
            return this.ipv6CidrBlockSet != null ? (Collection)this.ipv6CidrBlockSet.stream().map(Ipv6CidrBlock::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6CidrBlockSet(Collection<Ipv6CidrBlock> ipv6CidrBlockSet) {
            this.ipv6CidrBlockSet = Ipv6CidrBlockSetCopier.copy(ipv6CidrBlockSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockSet(Ipv6CidrBlock ... ipv6CidrBlockSet) {
            this.ipv6CidrBlockSet(Arrays.asList(ipv6CidrBlockSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockSet(Consumer<Ipv6CidrBlock.Builder> ... ipv6CidrBlockSet) {
            this.ipv6CidrBlockSet(Stream.of(ipv6CidrBlockSet).map(c -> (Ipv6CidrBlock)((Ipv6CidrBlock.Builder)Ipv6CidrBlock.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpv6CidrBlockSet(Collection<Ipv6CidrBlock.BuilderImpl> ipv6CidrBlockSet) {
            this.ipv6CidrBlockSet = Ipv6CidrBlockSetCopier.copyFromBuilder(ipv6CidrBlockSet);
        }

        public final Collection<CidrBlock.Builder> getCidrBlockSet() {
            return this.cidrBlockSet != null ? (Collection)this.cidrBlockSet.stream().map(CidrBlock::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cidrBlockSet(Collection<CidrBlock> cidrBlockSet) {
            this.cidrBlockSet = CidrBlockSetCopier.copy(cidrBlockSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlockSet(CidrBlock ... cidrBlockSet) {
            this.cidrBlockSet(Arrays.asList(cidrBlockSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlockSet(Consumer<CidrBlock.Builder> ... cidrBlockSet) {
            this.cidrBlockSet(Stream.of(cidrBlockSet).map(c -> (CidrBlock)((CidrBlock.Builder)CidrBlock.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCidrBlockSet(Collection<CidrBlock.BuilderImpl> cidrBlockSet) {
            this.cidrBlockSet = CidrBlockSetCopier.copyFromBuilder(cidrBlockSet);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final VpcPeeringConnectionOptionsDescription.Builder getPeeringOptions() {
            return this.peeringOptions != null ? this.peeringOptions.toBuilder() : null;
        }

        @Override
        public final Builder peeringOptions(VpcPeeringConnectionOptionsDescription peeringOptions) {
            this.peeringOptions = peeringOptions;
            return this;
        }

        public final void setPeeringOptions(VpcPeeringConnectionOptionsDescription.BuilderImpl peeringOptions) {
            this.peeringOptions = peeringOptions != null ? peeringOptions.build() : null;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public VpcPeeringConnectionVpcInfo build() {
            return new VpcPeeringConnectionVpcInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VpcPeeringConnectionVpcInfo> {
        public Builder cidrBlock(String var1);

        public Builder ipv6CidrBlockSet(Collection<Ipv6CidrBlock> var1);

        public Builder ipv6CidrBlockSet(Ipv6CidrBlock ... var1);

        public Builder ipv6CidrBlockSet(Consumer<Ipv6CidrBlock.Builder> ... var1);

        public Builder cidrBlockSet(Collection<CidrBlock> var1);

        public Builder cidrBlockSet(CidrBlock ... var1);

        public Builder cidrBlockSet(Consumer<CidrBlock.Builder> ... var1);

        public Builder ownerId(String var1);

        public Builder peeringOptions(VpcPeeringConnectionOptionsDescription var1);

        default public Builder peeringOptions(Consumer<VpcPeeringConnectionOptionsDescription.Builder> peeringOptions) {
            return this.peeringOptions((VpcPeeringConnectionOptionsDescription)((VpcPeeringConnectionOptionsDescription.Builder)VpcPeeringConnectionOptionsDescription.builder().applyMutation(peeringOptions)).build());
        }

        public Builder vpcId(String var1);

        public Builder region(String var1);
    }
}

