/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.Ipv6AddressListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UnassignIpv6AddressesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, UnassignIpv6AddressesResponse> {
    private final String networkInterfaceId;
    private final List<String> unassignedIpv6Addresses;

    private UnassignIpv6AddressesResponse(BuilderImpl builder) {
        super(builder);
        this.networkInterfaceId = builder.networkInterfaceId;
        this.unassignedIpv6Addresses = builder.unassignedIpv6Addresses;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public List<String> unassignedIpv6Addresses() {
        return this.unassignedIpv6Addresses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.unassignedIpv6Addresses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnassignIpv6AddressesResponse)) {
            return false;
        }
        UnassignIpv6AddressesResponse other = (UnassignIpv6AddressesResponse)((Object)obj);
        return Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.unassignedIpv6Addresses(), other.unassignedIpv6Addresses());
    }

    public String toString() {
        return ToString.builder((String)"UnassignIpv6AddressesResponse").add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("UnassignedIpv6Addresses", this.unassignedIpv6Addresses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "UnassignedIpv6Addresses": {
                return Optional.ofNullable(clazz.cast(this.unassignedIpv6Addresses()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String networkInterfaceId;
        private List<String> unassignedIpv6Addresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UnassignIpv6AddressesResponse model) {
            super(model);
            this.networkInterfaceId(model.networkInterfaceId);
            this.unassignedIpv6Addresses(model.unassignedIpv6Addresses);
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final Collection<String> getUnassignedIpv6Addresses() {
            return this.unassignedIpv6Addresses;
        }

        @Override
        public final Builder unassignedIpv6Addresses(Collection<String> unassignedIpv6Addresses) {
            this.unassignedIpv6Addresses = Ipv6AddressListCopier.copy(unassignedIpv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unassignedIpv6Addresses(String ... unassignedIpv6Addresses) {
            this.unassignedIpv6Addresses(Arrays.asList(unassignedIpv6Addresses));
            return this;
        }

        public final void setUnassignedIpv6Addresses(Collection<String> unassignedIpv6Addresses) {
            this.unassignedIpv6Addresses = Ipv6AddressListCopier.copy(unassignedIpv6Addresses);
        }

        @Override
        public UnassignIpv6AddressesResponse build() {
            return new UnassignIpv6AddressesResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, UnassignIpv6AddressesResponse> {
        public Builder networkInterfaceId(String var1);

        public Builder unassignedIpv6Addresses(Collection<String> var1);

        public Builder unassignedIpv6Addresses(String ... var1);
    }
}

