/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResetNetworkInterfaceAttributeRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ResetNetworkInterfaceAttributeRequest> {
    private final String networkInterfaceId;
    private final String sourceDestCheck;

    private ResetNetworkInterfaceAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.networkInterfaceId = builder.networkInterfaceId;
        this.sourceDestCheck = builder.sourceDestCheck;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public String sourceDestCheck() {
        return this.sourceDestCheck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDestCheck());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetNetworkInterfaceAttributeRequest)) {
            return false;
        }
        ResetNetworkInterfaceAttributeRequest other = (ResetNetworkInterfaceAttributeRequest)((Object)obj);
        return Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.sourceDestCheck(), other.sourceDestCheck());
    }

    public String toString() {
        return ToString.builder((String)"ResetNetworkInterfaceAttributeRequest").add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("SourceDestCheck", (Object)this.sourceDestCheck()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "SourceDestCheck": {
                return Optional.ofNullable(clazz.cast(this.sourceDestCheck()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String networkInterfaceId;
        private String sourceDestCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetNetworkInterfaceAttributeRequest model) {
            super(model);
            this.networkInterfaceId(model.networkInterfaceId);
            this.sourceDestCheck(model.sourceDestCheck);
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(String sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(String sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResetNetworkInterfaceAttributeRequest build() {
            return new ResetNetworkInterfaceAttributeRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, ResetNetworkInterfaceAttributeRequest> {
        public Builder networkInterfaceId(String var1);

        public Builder sourceDestCheck(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

