/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RejectVpcEndpointConnectionsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, RejectVpcEndpointConnectionsRequest> {
    private final String serviceId;
    private final List<String> vpcEndpointIds;

    private RejectVpcEndpointConnectionsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceId = builder.serviceId;
        this.vpcEndpointIds = builder.vpcEndpointIds;
    }

    public String serviceId() {
        return this.serviceId;
    }

    public List<String> vpcEndpointIds() {
        return this.vpcEndpointIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcEndpointIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectVpcEndpointConnectionsRequest)) {
            return false;
        }
        RejectVpcEndpointConnectionsRequest other = (RejectVpcEndpointConnectionsRequest)((Object)obj);
        return Objects.equals(this.serviceId(), other.serviceId()) && Objects.equals(this.vpcEndpointIds(), other.vpcEndpointIds());
    }

    public String toString() {
        return ToString.builder((String)"RejectVpcEndpointConnectionsRequest").add("ServiceId", (Object)this.serviceId()).add("VpcEndpointIds", this.vpcEndpointIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceId": {
                return Optional.ofNullable(clazz.cast(this.serviceId()));
            }
            case "VpcEndpointIds": {
                return Optional.ofNullable(clazz.cast(this.vpcEndpointIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String serviceId;
        private List<String> vpcEndpointIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RejectVpcEndpointConnectionsRequest model) {
            super(model);
            this.serviceId(model.serviceId);
            this.vpcEndpointIds(model.vpcEndpointIds);
        }

        public final String getServiceId() {
            return this.serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public final Collection<String> getVpcEndpointIds() {
            return this.vpcEndpointIds;
        }

        @Override
        public final Builder vpcEndpointIds(Collection<String> vpcEndpointIds) {
            this.vpcEndpointIds = ValueStringListCopier.copy(vpcEndpointIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointIds(String ... vpcEndpointIds) {
            this.vpcEndpointIds(Arrays.asList(vpcEndpointIds));
            return this;
        }

        public final void setVpcEndpointIds(Collection<String> vpcEndpointIds) {
            this.vpcEndpointIds = ValueStringListCopier.copy(vpcEndpointIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RejectVpcEndpointConnectionsRequest build() {
            return new RejectVpcEndpointConnectionsRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, RejectVpcEndpointConnectionsRequest> {
        public Builder serviceId(String var1);

        public Builder vpcEndpointIds(Collection<String> var1);

        public Builder vpcEndpointIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

