/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.IdFormat;
import software.amazon.awssdk.services.ec2.model.IdFormatListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PrincipalIdFormat
implements ToCopyableBuilder<Builder, PrincipalIdFormat> {
    private final String arn;
    private final List<IdFormat> statuses;

    private PrincipalIdFormat(BuilderImpl builder) {
        this.arn = builder.arn;
        this.statuses = builder.statuses;
    }

    public String arn() {
        return this.arn;
    }

    public List<IdFormat> statuses() {
        return this.statuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statuses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrincipalIdFormat)) {
            return false;
        }
        PrincipalIdFormat other = (PrincipalIdFormat)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statuses(), other.statuses());
    }

    public String toString() {
        return ToString.builder((String)"PrincipalIdFormat").add("Arn", (Object)this.arn()).add("Statuses", this.statuses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Statuses": {
                return Optional.ofNullable(clazz.cast(this.statuses()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private List<IdFormat> statuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PrincipalIdFormat model) {
            this.arn(model.arn);
            this.statuses(model.statuses);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Collection<IdFormat.Builder> getStatuses() {
            return this.statuses != null ? (Collection)this.statuses.stream().map(IdFormat::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder statuses(Collection<IdFormat> statuses) {
            this.statuses = IdFormatListCopier.copy(statuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(IdFormat ... statuses) {
            this.statuses(Arrays.asList(statuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statuses(Consumer<IdFormat.Builder> ... statuses) {
            this.statuses(Stream.of(statuses).map(c -> (IdFormat)((IdFormat.Builder)IdFormat.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStatuses(Collection<IdFormat.BuilderImpl> statuses) {
            this.statuses = IdFormatListCopier.copyFromBuilder(statuses);
        }

        public PrincipalIdFormat build() {
            return new PrincipalIdFormat(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PrincipalIdFormat> {
        public Builder arn(String var1);

        public Builder statuses(Collection<IdFormat> var1);

        public Builder statuses(IdFormat ... var1);

        public Builder statuses(Consumer<IdFormat.Builder> ... var1);
    }
}

