/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkInterfaceAttachmentChanges
implements ToCopyableBuilder<Builder, NetworkInterfaceAttachmentChanges> {
    private final String attachmentId;
    private final Boolean deleteOnTermination;

    private NetworkInterfaceAttachmentChanges(BuilderImpl builder) {
        this.attachmentId = builder.attachmentId;
        this.deleteOnTermination = builder.deleteOnTermination;
    }

    public String attachmentId() {
        return this.attachmentId;
    }

    public Boolean deleteOnTermination() {
        return this.deleteOnTermination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteOnTermination());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterfaceAttachmentChanges)) {
            return false;
        }
        NetworkInterfaceAttachmentChanges other = (NetworkInterfaceAttachmentChanges)obj;
        return Objects.equals(this.attachmentId(), other.attachmentId()) && Objects.equals(this.deleteOnTermination(), other.deleteOnTermination());
    }

    public String toString() {
        return ToString.builder((String)"NetworkInterfaceAttachmentChanges").add("AttachmentId", (Object)this.attachmentId()).add("DeleteOnTermination", (Object)this.deleteOnTermination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachmentId": {
                return Optional.ofNullable(clazz.cast(this.attachmentId()));
            }
            case "DeleteOnTermination": {
                return Optional.ofNullable(clazz.cast(this.deleteOnTermination()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String attachmentId;
        private Boolean deleteOnTermination;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterfaceAttachmentChanges model) {
            this.attachmentId(model.attachmentId);
            this.deleteOnTermination(model.deleteOnTermination);
        }

        public final String getAttachmentId() {
            return this.attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        public final Boolean getDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        public NetworkInterfaceAttachmentChanges build() {
            return new NetworkInterfaceAttachmentChanges(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NetworkInterfaceAttachmentChanges> {
        public Builder attachmentId(String var1);

        public Builder deleteOnTermination(Boolean var1);
    }
}

