/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.MoveStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MovingAddressStatus
implements ToCopyableBuilder<Builder, MovingAddressStatus> {
    private final String moveStatus;
    private final String publicIp;

    private MovingAddressStatus(BuilderImpl builder) {
        this.moveStatus = builder.moveStatus;
        this.publicIp = builder.publicIp;
    }

    public MoveStatus moveStatus() {
        return MoveStatus.fromValue(this.moveStatus);
    }

    public String moveStatusAsString() {
        return this.moveStatus;
    }

    public String publicIp() {
        return this.publicIp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.moveStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MovingAddressStatus)) {
            return false;
        }
        MovingAddressStatus other = (MovingAddressStatus)obj;
        return Objects.equals(this.moveStatusAsString(), other.moveStatusAsString()) && Objects.equals(this.publicIp(), other.publicIp());
    }

    public String toString() {
        return ToString.builder((String)"MovingAddressStatus").add("MoveStatus", (Object)this.moveStatusAsString()).add("PublicIp", (Object)this.publicIp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MoveStatus": {
                return Optional.ofNullable(clazz.cast(this.moveStatusAsString()));
            }
            case "PublicIp": {
                return Optional.ofNullable(clazz.cast(this.publicIp()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String moveStatus;
        private String publicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(MovingAddressStatus model) {
            this.moveStatus(model.moveStatus);
            this.publicIp(model.publicIp);
        }

        public final String getMoveStatus() {
            return this.moveStatus;
        }

        @Override
        public final Builder moveStatus(String moveStatus) {
            this.moveStatus = moveStatus;
            return this;
        }

        @Override
        public final Builder moveStatus(MoveStatus moveStatus) {
            this.moveStatus(moveStatus.toString());
            return this;
        }

        public final void setMoveStatus(String moveStatus) {
            this.moveStatus = moveStatus;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public MovingAddressStatus build() {
            return new MovingAddressStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MovingAddressStatus> {
        public Builder moveStatus(String var1);

        public Builder moveStatus(MoveStatus var1);

        public Builder publicIp(String var1);
    }
}

