/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.GroupIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceAttributeName;
import software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMappingSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMappingSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyInstanceAttributeRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyInstanceAttributeRequest> {
    private final Boolean sourceDestCheck;
    private final String attribute;
    private final List<InstanceBlockDeviceMappingSpecification> blockDeviceMappings;
    private final Boolean disableApiTermination;
    private final Boolean ebsOptimized;
    private final Boolean enaSupport;
    private final List<String> groups;
    private final String instanceId;
    private final String instanceInitiatedShutdownBehavior;
    private final String instanceType;
    private final String kernel;
    private final String ramdisk;
    private final String sriovNetSupport;
    private final String userData;
    private final String value;

    private ModifyInstanceAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.sourceDestCheck = builder.sourceDestCheck;
        this.attribute = builder.attribute;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.disableApiTermination = builder.disableApiTermination;
        this.ebsOptimized = builder.ebsOptimized;
        this.enaSupport = builder.enaSupport;
        this.groups = builder.groups;
        this.instanceId = builder.instanceId;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.instanceType = builder.instanceType;
        this.kernel = builder.kernel;
        this.ramdisk = builder.ramdisk;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.userData = builder.userData;
        this.value = builder.value;
    }

    public Boolean sourceDestCheck() {
        return this.sourceDestCheck;
    }

    public InstanceAttributeName attribute() {
        return InstanceAttributeName.fromValue(this.attribute);
    }

    public String attributeAsString() {
        return this.attribute;
    }

    public List<InstanceBlockDeviceMappingSpecification> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public Boolean disableApiTermination() {
        return this.disableApiTermination;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public Boolean enaSupport() {
        return this.enaSupport;
    }

    public List<String> groups() {
        return this.groups;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String instanceInitiatedShutdownBehavior() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String kernel() {
        return this.kernel;
    }

    public String ramdisk() {
        return this.ramdisk;
    }

    public String sriovNetSupport() {
        return this.sriovNetSupport;
    }

    public String userData() {
        return this.userData;
    }

    public String value() {
        return this.value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDestCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockDeviceMappings());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableApiTermination());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.enaSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.groups());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceInitiatedShutdownBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernel());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramdisk());
        hashCode = 31 * hashCode + Objects.hashCode(this.sriovNetSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyInstanceAttributeRequest)) {
            return false;
        }
        ModifyInstanceAttributeRequest other = (ModifyInstanceAttributeRequest)((Object)obj);
        return Objects.equals(this.sourceDestCheck(), other.sourceDestCheck()) && Objects.equals(this.attributeAsString(), other.attributeAsString()) && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && Objects.equals(this.disableApiTermination(), other.disableApiTermination()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.enaSupport(), other.enaSupport()) && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.instanceInitiatedShutdownBehavior(), other.instanceInitiatedShutdownBehavior()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.kernel(), other.kernel()) && Objects.equals(this.ramdisk(), other.ramdisk()) && Objects.equals(this.sriovNetSupport(), other.sriovNetSupport()) && Objects.equals(this.userData(), other.userData()) && Objects.equals(this.value(), other.value());
    }

    public String toString() {
        return ToString.builder((String)"ModifyInstanceAttributeRequest").add("SourceDestCheck", (Object)this.sourceDestCheck()).add("Attribute", (Object)this.attributeAsString()).add("BlockDeviceMappings", this.blockDeviceMappings()).add("DisableApiTermination", (Object)this.disableApiTermination()).add("EbsOptimized", (Object)this.ebsOptimized()).add("EnaSupport", (Object)this.enaSupport()).add("Groups", this.groups()).add("InstanceId", (Object)this.instanceId()).add("InstanceInitiatedShutdownBehavior", (Object)this.instanceInitiatedShutdownBehavior()).add("InstanceType", (Object)this.instanceType()).add("Kernel", (Object)this.kernel()).add("Ramdisk", (Object)this.ramdisk()).add("SriovNetSupport", (Object)this.sriovNetSupport()).add("UserData", (Object)this.userData()).add("Value", (Object)this.value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceDestCheck": {
                return Optional.ofNullable(clazz.cast(this.sourceDestCheck()));
            }
            case "Attribute": {
                return Optional.ofNullable(clazz.cast(this.attributeAsString()));
            }
            case "BlockDeviceMappings": {
                return Optional.ofNullable(clazz.cast(this.blockDeviceMappings()));
            }
            case "DisableApiTermination": {
                return Optional.ofNullable(clazz.cast(this.disableApiTermination()));
            }
            case "EbsOptimized": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimized()));
            }
            case "EnaSupport": {
                return Optional.ofNullable(clazz.cast(this.enaSupport()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "InstanceInitiatedShutdownBehavior": {
                return Optional.ofNullable(clazz.cast(this.instanceInitiatedShutdownBehavior()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "Kernel": {
                return Optional.ofNullable(clazz.cast(this.kernel()));
            }
            case "Ramdisk": {
                return Optional.ofNullable(clazz.cast(this.ramdisk()));
            }
            case "SriovNetSupport": {
                return Optional.ofNullable(clazz.cast(this.sriovNetSupport()));
            }
            case "UserData": {
                return Optional.ofNullable(clazz.cast(this.userData()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean sourceDestCheck;
        private String attribute;
        private List<InstanceBlockDeviceMappingSpecification> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();
        private Boolean disableApiTermination;
        private Boolean ebsOptimized;
        private Boolean enaSupport;
        private List<String> groups = DefaultSdkAutoConstructList.getInstance();
        private String instanceId;
        private String instanceInitiatedShutdownBehavior;
        private String instanceType;
        private String kernel;
        private String ramdisk;
        private String sriovNetSupport;
        private String userData;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyInstanceAttributeRequest model) {
            super(model);
            this.sourceDestCheck(model.sourceDestCheck);
            this.attribute(model.attribute);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.disableApiTermination(model.disableApiTermination);
            this.ebsOptimized(model.ebsOptimized);
            this.enaSupport(model.enaSupport);
            this.groups(model.groups);
            this.instanceId(model.instanceId);
            this.instanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            this.instanceType(model.instanceType);
            this.kernel(model.kernel);
            this.ramdisk(model.ramdisk);
            this.sriovNetSupport(model.sriovNetSupport);
            this.userData(model.userData);
            this.value(model.value);
        }

        public final Boolean getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        public final String getAttribute() {
            return this.attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(InstanceAttributeName attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final Collection<InstanceBlockDeviceMappingSpecification.Builder> getBlockDeviceMappings() {
            return this.blockDeviceMappings != null ? (Collection)this.blockDeviceMappings.stream().map(InstanceBlockDeviceMappingSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<InstanceBlockDeviceMappingSpecification> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingSpecificationListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(InstanceBlockDeviceMappingSpecification ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMappingSpecification.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (InstanceBlockDeviceMappingSpecification)((InstanceBlockDeviceMappingSpecification.Builder)InstanceBlockDeviceMappingSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<InstanceBlockDeviceMappingSpecification.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingSpecificationListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final Boolean getDisableApiTermination() {
            return this.disableApiTermination;
        }

        @Override
        public final Builder disableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        public final void setDisableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final Boolean getEnaSupport() {
            return this.enaSupport;
        }

        @Override
        public final Builder enaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final void setEnaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
        }

        public final Collection<String> getGroups() {
            return this.groups;
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = GroupIdStringListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = GroupIdStringListCopier.copy(groups);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceInitiatedShutdownBehavior() {
            return this.instanceInitiatedShutdownBehavior;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        public final void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernel() {
            return this.kernel;
        }

        @Override
        public final Builder kernel(String kernel) {
            this.kernel = kernel;
            return this;
        }

        public final void setKernel(String kernel) {
            this.kernel = kernel;
        }

        public final String getRamdisk() {
            return this.ramdisk;
        }

        @Override
        public final Builder ramdisk(String ramdisk) {
            this.ramdisk = ramdisk;
            return this;
        }

        public final void setRamdisk(String ramdisk) {
            this.ramdisk = ramdisk;
        }

        public final String getSriovNetSupport() {
            return this.sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        public final String getUserData() {
            return this.userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyInstanceAttributeRequest build() {
            return new ModifyInstanceAttributeRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, ModifyInstanceAttributeRequest> {
        public Builder sourceDestCheck(Boolean var1);

        public Builder attribute(String var1);

        public Builder attribute(InstanceAttributeName var1);

        public Builder blockDeviceMappings(Collection<InstanceBlockDeviceMappingSpecification> var1);

        public Builder blockDeviceMappings(InstanceBlockDeviceMappingSpecification ... var1);

        public Builder blockDeviceMappings(Consumer<InstanceBlockDeviceMappingSpecification.Builder> ... var1);

        public Builder disableApiTermination(Boolean var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder enaSupport(Boolean var1);

        public Builder groups(Collection<String> var1);

        public Builder groups(String ... var1);

        public Builder instanceId(String var1);

        public Builder instanceInitiatedShutdownBehavior(String var1);

        public Builder instanceType(String var1);

        public Builder kernel(String var1);

        public Builder ramdisk(String var1);

        public Builder sriovNetSupport(String var1);

        public Builder userData(String var1);

        public Builder value(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

