/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ec2.model.ResponseLaunchTemplateData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchTemplateVersion
implements ToCopyableBuilder<Builder, LaunchTemplateVersion> {
    private final String launchTemplateId;
    private final String launchTemplateName;
    private final Long versionNumber;
    private final String versionDescription;
    private final Instant createTime;
    private final String createdBy;
    private final Boolean defaultVersion;
    private final ResponseLaunchTemplateData launchTemplateData;

    private LaunchTemplateVersion(BuilderImpl builder) {
        this.launchTemplateId = builder.launchTemplateId;
        this.launchTemplateName = builder.launchTemplateName;
        this.versionNumber = builder.versionNumber;
        this.versionDescription = builder.versionDescription;
        this.createTime = builder.createTime;
        this.createdBy = builder.createdBy;
        this.defaultVersion = builder.defaultVersion;
        this.launchTemplateData = builder.launchTemplateData;
    }

    public String launchTemplateId() {
        return this.launchTemplateId;
    }

    public String launchTemplateName() {
        return this.launchTemplateName;
    }

    public Long versionNumber() {
        return this.versionNumber;
    }

    public String versionDescription() {
        return this.versionDescription;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public String createdBy() {
        return this.createdBy;
    }

    public Boolean defaultVersion() {
        return this.defaultVersion;
    }

    public ResponseLaunchTemplateData launchTemplateData() {
        return this.launchTemplateData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateVersion)) {
            return false;
        }
        LaunchTemplateVersion other = (LaunchTemplateVersion)obj;
        return Objects.equals(this.launchTemplateId(), other.launchTemplateId()) && Objects.equals(this.launchTemplateName(), other.launchTemplateName()) && Objects.equals(this.versionNumber(), other.versionNumber()) && Objects.equals(this.versionDescription(), other.versionDescription()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.defaultVersion(), other.defaultVersion()) && Objects.equals(this.launchTemplateData(), other.launchTemplateData());
    }

    public String toString() {
        return ToString.builder((String)"LaunchTemplateVersion").add("LaunchTemplateId", (Object)this.launchTemplateId()).add("LaunchTemplateName", (Object)this.launchTemplateName()).add("VersionNumber", (Object)this.versionNumber()).add("VersionDescription", (Object)this.versionDescription()).add("CreateTime", (Object)this.createTime()).add("CreatedBy", (Object)this.createdBy()).add("DefaultVersion", (Object)this.defaultVersion()).add("LaunchTemplateData", (Object)this.launchTemplateData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchTemplateId": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateId()));
            }
            case "LaunchTemplateName": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateName()));
            }
            case "VersionNumber": {
                return Optional.ofNullable(clazz.cast(this.versionNumber()));
            }
            case "VersionDescription": {
                return Optional.ofNullable(clazz.cast(this.versionDescription()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "DefaultVersion": {
                return Optional.ofNullable(clazz.cast(this.defaultVersion()));
            }
            case "LaunchTemplateData": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateData()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String launchTemplateId;
        private String launchTemplateName;
        private Long versionNumber;
        private String versionDescription;
        private Instant createTime;
        private String createdBy;
        private Boolean defaultVersion;
        private ResponseLaunchTemplateData launchTemplateData;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateVersion model) {
            this.launchTemplateId(model.launchTemplateId);
            this.launchTemplateName(model.launchTemplateName);
            this.versionNumber(model.versionNumber);
            this.versionDescription(model.versionDescription);
            this.createTime(model.createTime);
            this.createdBy(model.createdBy);
            this.defaultVersion(model.defaultVersion);
            this.launchTemplateData(model.launchTemplateData);
        }

        public final String getLaunchTemplateId() {
            return this.launchTemplateId;
        }

        @Override
        public final Builder launchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
            return this;
        }

        public final void setLaunchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
        }

        public final String getLaunchTemplateName() {
            return this.launchTemplateName;
        }

        @Override
        public final Builder launchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
            return this;
        }

        public final void setLaunchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
        }

        public final Long getVersionNumber() {
            return this.versionNumber;
        }

        @Override
        public final Builder versionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
            return this;
        }

        public final void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public final String getVersionDescription() {
            return this.versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        public final Boolean getDefaultVersion() {
            return this.defaultVersion;
        }

        @Override
        public final Builder defaultVersion(Boolean defaultVersion) {
            this.defaultVersion = defaultVersion;
            return this;
        }

        public final void setDefaultVersion(Boolean defaultVersion) {
            this.defaultVersion = defaultVersion;
        }

        public final ResponseLaunchTemplateData.Builder getLaunchTemplateData() {
            return this.launchTemplateData != null ? this.launchTemplateData.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplateData(ResponseLaunchTemplateData launchTemplateData) {
            this.launchTemplateData = launchTemplateData;
            return this;
        }

        public final void setLaunchTemplateData(ResponseLaunchTemplateData.BuilderImpl launchTemplateData) {
            this.launchTemplateData = launchTemplateData != null ? launchTemplateData.build() : null;
        }

        public LaunchTemplateVersion build() {
            return new LaunchTemplateVersion(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LaunchTemplateVersion> {
        public Builder launchTemplateId(String var1);

        public Builder launchTemplateName(String var1);

        public Builder versionNumber(Long var1);

        public Builder versionDescription(String var1);

        public Builder createTime(Instant var1);

        public Builder createdBy(String var1);

        public Builder defaultVersion(Boolean var1);

        public Builder launchTemplateData(ResponseLaunchTemplateData var1);

        default public Builder launchTemplateData(Consumer<ResponseLaunchTemplateData.Builder> launchTemplateData) {
            return this.launchTemplateData((ResponseLaunchTemplateData)((ResponseLaunchTemplateData.Builder)ResponseLaunchTemplateData.builder().applyMutation(launchTemplateData)).build());
        }
    }
}

