/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateSpotMarketOptions;
import software.amazon.awssdk.services.ec2.model.MarketType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchTemplateInstanceMarketOptions
implements ToCopyableBuilder<Builder, LaunchTemplateInstanceMarketOptions> {
    private final String marketType;
    private final LaunchTemplateSpotMarketOptions spotOptions;

    private LaunchTemplateInstanceMarketOptions(BuilderImpl builder) {
        this.marketType = builder.marketType;
        this.spotOptions = builder.spotOptions;
    }

    public MarketType marketType() {
        return MarketType.fromValue(this.marketType);
    }

    public String marketTypeAsString() {
        return this.marketType;
    }

    public LaunchTemplateSpotMarketOptions spotOptions() {
        return this.spotOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marketTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateInstanceMarketOptions)) {
            return false;
        }
        LaunchTemplateInstanceMarketOptions other = (LaunchTemplateInstanceMarketOptions)obj;
        return Objects.equals(this.marketTypeAsString(), other.marketTypeAsString()) && Objects.equals(this.spotOptions(), other.spotOptions());
    }

    public String toString() {
        return ToString.builder((String)"LaunchTemplateInstanceMarketOptions").add("MarketType", (Object)this.marketTypeAsString()).add("SpotOptions", (Object)this.spotOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MarketType": {
                return Optional.ofNullable(clazz.cast(this.marketTypeAsString()));
            }
            case "SpotOptions": {
                return Optional.ofNullable(clazz.cast(this.spotOptions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String marketType;
        private LaunchTemplateSpotMarketOptions spotOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateInstanceMarketOptions model) {
            this.marketType(model.marketType);
            this.spotOptions(model.spotOptions);
        }

        public final String getMarketType() {
            return this.marketType;
        }

        @Override
        public final Builder marketType(String marketType) {
            this.marketType = marketType;
            return this;
        }

        @Override
        public final Builder marketType(MarketType marketType) {
            this.marketType(marketType.toString());
            return this;
        }

        public final void setMarketType(String marketType) {
            this.marketType = marketType;
        }

        public final LaunchTemplateSpotMarketOptions.Builder getSpotOptions() {
            return this.spotOptions != null ? this.spotOptions.toBuilder() : null;
        }

        @Override
        public final Builder spotOptions(LaunchTemplateSpotMarketOptions spotOptions) {
            this.spotOptions = spotOptions;
            return this;
        }

        public final void setSpotOptions(LaunchTemplateSpotMarketOptions.BuilderImpl spotOptions) {
            this.spotOptions = spotOptions != null ? spotOptions.build() : null;
        }

        public LaunchTemplateInstanceMarketOptions build() {
            return new LaunchTemplateInstanceMarketOptions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LaunchTemplateInstanceMarketOptions> {
        public Builder marketType(String var1);

        public Builder marketType(MarketType var1);

        public Builder spotOptions(LaunchTemplateSpotMarketOptions var1);

        default public Builder spotOptions(Consumer<LaunchTemplateSpotMarketOptions.Builder> spotOptions) {
            return this.spotOptions((LaunchTemplateSpotMarketOptions)((LaunchTemplateSpotMarketOptions.Builder)LaunchTemplateSpotMarketOptions.builder().applyMutation(spotOptions)).build());
        }
    }
}

