/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.IpRange;
import software.amazon.awssdk.services.ec2.model.IpRangeListCopier;
import software.amazon.awssdk.services.ec2.model.Ipv6Range;
import software.amazon.awssdk.services.ec2.model.Ipv6RangeListCopier;
import software.amazon.awssdk.services.ec2.model.PrefixListId;
import software.amazon.awssdk.services.ec2.model.PrefixListIdListCopier;
import software.amazon.awssdk.services.ec2.model.UserIdGroupPair;
import software.amazon.awssdk.services.ec2.model.UserIdGroupPairListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpPermission
implements ToCopyableBuilder<Builder, IpPermission> {
    private final Integer fromPort;
    private final String ipProtocol;
    private final List<Ipv6Range> ipv6Ranges;
    private final List<PrefixListId> prefixListIds;
    private final Integer toPort;
    private final List<UserIdGroupPair> userIdGroupPairs;
    private final List<IpRange> ipv4Ranges;

    private IpPermission(BuilderImpl builder) {
        this.fromPort = builder.fromPort;
        this.ipProtocol = builder.ipProtocol;
        this.ipv6Ranges = builder.ipv6Ranges;
        this.prefixListIds = builder.prefixListIds;
        this.toPort = builder.toPort;
        this.userIdGroupPairs = builder.userIdGroupPairs;
        this.ipv4Ranges = builder.ipv4Ranges;
    }

    public Integer fromPort() {
        return this.fromPort;
    }

    public String ipProtocol() {
        return this.ipProtocol;
    }

    public List<Ipv6Range> ipv6Ranges() {
        return this.ipv6Ranges;
    }

    public List<PrefixListId> prefixListIds() {
        return this.prefixListIds;
    }

    public Integer toPort() {
        return this.toPort;
    }

    public List<UserIdGroupPair> userIdGroupPairs() {
        return this.userIdGroupPairs;
    }

    public List<IpRange> ipv4Ranges() {
        return this.ipv4Ranges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fromPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6Ranges());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefixListIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.toPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.userIdGroupPairs());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv4Ranges());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpPermission)) {
            return false;
        }
        IpPermission other = (IpPermission)obj;
        return Objects.equals(this.fromPort(), other.fromPort()) && Objects.equals(this.ipProtocol(), other.ipProtocol()) && Objects.equals(this.ipv6Ranges(), other.ipv6Ranges()) && Objects.equals(this.prefixListIds(), other.prefixListIds()) && Objects.equals(this.toPort(), other.toPort()) && Objects.equals(this.userIdGroupPairs(), other.userIdGroupPairs()) && Objects.equals(this.ipv4Ranges(), other.ipv4Ranges());
    }

    public String toString() {
        return ToString.builder((String)"IpPermission").add("FromPort", (Object)this.fromPort()).add("IpProtocol", (Object)this.ipProtocol()).add("Ipv6Ranges", this.ipv6Ranges()).add("PrefixListIds", this.prefixListIds()).add("ToPort", (Object)this.toPort()).add("UserIdGroupPairs", this.userIdGroupPairs()).add("Ipv4Ranges", this.ipv4Ranges()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FromPort": {
                return Optional.ofNullable(clazz.cast(this.fromPort()));
            }
            case "IpProtocol": {
                return Optional.ofNullable(clazz.cast(this.ipProtocol()));
            }
            case "Ipv6Ranges": {
                return Optional.ofNullable(clazz.cast(this.ipv6Ranges()));
            }
            case "PrefixListIds": {
                return Optional.ofNullable(clazz.cast(this.prefixListIds()));
            }
            case "ToPort": {
                return Optional.ofNullable(clazz.cast(this.toPort()));
            }
            case "UserIdGroupPairs": {
                return Optional.ofNullable(clazz.cast(this.userIdGroupPairs()));
            }
            case "Ipv4Ranges": {
                return Optional.ofNullable(clazz.cast(this.ipv4Ranges()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Integer fromPort;
        private String ipProtocol;
        private List<Ipv6Range> ipv6Ranges = DefaultSdkAutoConstructList.getInstance();
        private List<PrefixListId> prefixListIds = DefaultSdkAutoConstructList.getInstance();
        private Integer toPort;
        private List<UserIdGroupPair> userIdGroupPairs = DefaultSdkAutoConstructList.getInstance();
        private List<IpRange> ipv4Ranges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IpPermission model) {
            this.fromPort(model.fromPort);
            this.ipProtocol(model.ipProtocol);
            this.ipv6Ranges(model.ipv6Ranges);
            this.prefixListIds(model.prefixListIds);
            this.toPort(model.toPort);
            this.userIdGroupPairs(model.userIdGroupPairs);
            this.ipv4Ranges(model.ipv4Ranges);
        }

        public final Integer getFromPort() {
            return this.fromPort;
        }

        @Override
        public final Builder fromPort(Integer fromPort) {
            this.fromPort = fromPort;
            return this;
        }

        public final void setFromPort(Integer fromPort) {
            this.fromPort = fromPort;
        }

        public final String getIpProtocol() {
            return this.ipProtocol;
        }

        @Override
        public final Builder ipProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
            return this;
        }

        public final void setIpProtocol(String ipProtocol) {
            this.ipProtocol = ipProtocol;
        }

        public final Collection<Ipv6Range.Builder> getIpv6Ranges() {
            return this.ipv6Ranges != null ? (Collection)this.ipv6Ranges.stream().map(Ipv6Range::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6Ranges(Collection<Ipv6Range> ipv6Ranges) {
            this.ipv6Ranges = Ipv6RangeListCopier.copy(ipv6Ranges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Ranges(Ipv6Range ... ipv6Ranges) {
            this.ipv6Ranges(Arrays.asList(ipv6Ranges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Ranges(Consumer<Ipv6Range.Builder> ... ipv6Ranges) {
            this.ipv6Ranges(Stream.of(ipv6Ranges).map(c -> (Ipv6Range)((Ipv6Range.Builder)Ipv6Range.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpv6Ranges(Collection<Ipv6Range.BuilderImpl> ipv6Ranges) {
            this.ipv6Ranges = Ipv6RangeListCopier.copyFromBuilder(ipv6Ranges);
        }

        public final Collection<PrefixListId.Builder> getPrefixListIds() {
            return this.prefixListIds != null ? (Collection)this.prefixListIds.stream().map(PrefixListId::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder prefixListIds(Collection<PrefixListId> prefixListIds) {
            this.prefixListIds = PrefixListIdListCopier.copy(prefixListIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixListIds(PrefixListId ... prefixListIds) {
            this.prefixListIds(Arrays.asList(prefixListIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder prefixListIds(Consumer<PrefixListId.Builder> ... prefixListIds) {
            this.prefixListIds(Stream.of(prefixListIds).map(c -> (PrefixListId)((PrefixListId.Builder)PrefixListId.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPrefixListIds(Collection<PrefixListId.BuilderImpl> prefixListIds) {
            this.prefixListIds = PrefixListIdListCopier.copyFromBuilder(prefixListIds);
        }

        public final Integer getToPort() {
            return this.toPort;
        }

        @Override
        public final Builder toPort(Integer toPort) {
            this.toPort = toPort;
            return this;
        }

        public final void setToPort(Integer toPort) {
            this.toPort = toPort;
        }

        public final Collection<UserIdGroupPair.Builder> getUserIdGroupPairs() {
            return this.userIdGroupPairs != null ? (Collection)this.userIdGroupPairs.stream().map(UserIdGroupPair::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userIdGroupPairs(Collection<UserIdGroupPair> userIdGroupPairs) {
            this.userIdGroupPairs = UserIdGroupPairListCopier.copy(userIdGroupPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdGroupPairs(UserIdGroupPair ... userIdGroupPairs) {
            this.userIdGroupPairs(Arrays.asList(userIdGroupPairs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIdGroupPairs(Consumer<UserIdGroupPair.Builder> ... userIdGroupPairs) {
            this.userIdGroupPairs(Stream.of(userIdGroupPairs).map(c -> (UserIdGroupPair)((UserIdGroupPair.Builder)UserIdGroupPair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserIdGroupPairs(Collection<UserIdGroupPair.BuilderImpl> userIdGroupPairs) {
            this.userIdGroupPairs = UserIdGroupPairListCopier.copyFromBuilder(userIdGroupPairs);
        }

        public final Collection<IpRange.Builder> getIpv4Ranges() {
            return this.ipv4Ranges != null ? (Collection)this.ipv4Ranges.stream().map(IpRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv4Ranges(Collection<IpRange> ipv4Ranges) {
            this.ipv4Ranges = IpRangeListCopier.copy(ipv4Ranges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Ranges(IpRange ... ipv4Ranges) {
            this.ipv4Ranges(Arrays.asList(ipv4Ranges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Ranges(Consumer<IpRange.Builder> ... ipv4Ranges) {
            this.ipv4Ranges(Stream.of(ipv4Ranges).map(c -> (IpRange)((IpRange.Builder)IpRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpv4Ranges(Collection<IpRange.BuilderImpl> ipv4Ranges) {
            this.ipv4Ranges = IpRangeListCopier.copyFromBuilder(ipv4Ranges);
        }

        public IpPermission build() {
            return new IpPermission(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IpPermission> {
        public Builder fromPort(Integer var1);

        public Builder ipProtocol(String var1);

        public Builder ipv6Ranges(Collection<Ipv6Range> var1);

        public Builder ipv6Ranges(Ipv6Range ... var1);

        public Builder ipv6Ranges(Consumer<Ipv6Range.Builder> ... var1);

        public Builder prefixListIds(Collection<PrefixListId> var1);

        public Builder prefixListIds(PrefixListId ... var1);

        public Builder prefixListIds(Consumer<PrefixListId.Builder> ... var1);

        public Builder toPort(Integer var1);

        public Builder userIdGroupPairs(Collection<UserIdGroupPair> var1);

        public Builder userIdGroupPairs(UserIdGroupPair ... var1);

        public Builder userIdGroupPairs(Consumer<UserIdGroupPair.Builder> ... var1);

        public Builder ipv4Ranges(Collection<IpRange> var1);

        public Builder ipv4Ranges(IpRange ... var1);

        public Builder ipv4Ranges(Consumer<IpRange.Builder> ... var1);
    }
}

