/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ClientData;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ImageDiskContainer;
import software.amazon.awssdk.services.ec2.model.ImageDiskContainerListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportImageRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ImportImageRequest> {
    private final String architecture;
    private final ClientData clientData;
    private final String clientToken;
    private final String description;
    private final List<ImageDiskContainer> diskContainers;
    private final String hypervisor;
    private final String licenseType;
    private final String platform;
    private final String roleName;

    private ImportImageRequest(BuilderImpl builder) {
        super(builder);
        this.architecture = builder.architecture;
        this.clientData = builder.clientData;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.diskContainers = builder.diskContainers;
        this.hypervisor = builder.hypervisor;
        this.licenseType = builder.licenseType;
        this.platform = builder.platform;
        this.roleName = builder.roleName;
    }

    public String architecture() {
        return this.architecture;
    }

    public ClientData clientData() {
        return this.clientData;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String description() {
        return this.description;
    }

    public List<ImageDiskContainer> diskContainers() {
        return this.diskContainers;
    }

    public String hypervisor() {
        return this.hypervisor;
    }

    public String licenseType() {
        return this.licenseType;
    }

    public String platform() {
        return this.platform;
    }

    public String roleName() {
        return this.roleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.architecture());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientData());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskContainers());
        hashCode = 31 * hashCode + Objects.hashCode(this.hypervisor());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseType());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportImageRequest)) {
            return false;
        }
        ImportImageRequest other = (ImportImageRequest)((Object)obj);
        return Objects.equals(this.architecture(), other.architecture()) && Objects.equals(this.clientData(), other.clientData()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.diskContainers(), other.diskContainers()) && Objects.equals(this.hypervisor(), other.hypervisor()) && Objects.equals(this.licenseType(), other.licenseType()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.roleName(), other.roleName());
    }

    public String toString() {
        return ToString.builder((String)"ImportImageRequest").add("Architecture", (Object)this.architecture()).add("ClientData", (Object)this.clientData()).add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("DiskContainers", this.diskContainers()).add("Hypervisor", (Object)this.hypervisor()).add("LicenseType", (Object)this.licenseType()).add("Platform", (Object)this.platform()).add("RoleName", (Object)this.roleName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Architecture": {
                return Optional.ofNullable(clazz.cast(this.architecture()));
            }
            case "ClientData": {
                return Optional.ofNullable(clazz.cast(this.clientData()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DiskContainers": {
                return Optional.ofNullable(clazz.cast(this.diskContainers()));
            }
            case "Hypervisor": {
                return Optional.ofNullable(clazz.cast(this.hypervisor()));
            }
            case "LicenseType": {
                return Optional.ofNullable(clazz.cast(this.licenseType()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "RoleName": {
                return Optional.ofNullable(clazz.cast(this.roleName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String architecture;
        private ClientData clientData;
        private String clientToken;
        private String description;
        private List<ImageDiskContainer> diskContainers = DefaultSdkAutoConstructList.getInstance();
        private String hypervisor;
        private String licenseType;
        private String platform;
        private String roleName;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportImageRequest model) {
            super(model);
            this.architecture(model.architecture);
            this.clientData(model.clientData);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.diskContainers(model.diskContainers);
            this.hypervisor(model.hypervisor);
            this.licenseType(model.licenseType);
            this.platform(model.platform);
            this.roleName(model.roleName);
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final ClientData.Builder getClientData() {
            return this.clientData != null ? this.clientData.toBuilder() : null;
        }

        @Override
        public final Builder clientData(ClientData clientData) {
            this.clientData = clientData;
            return this;
        }

        public final void setClientData(ClientData.BuilderImpl clientData) {
            this.clientData = clientData != null ? clientData.build() : null;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<ImageDiskContainer.Builder> getDiskContainers() {
            return this.diskContainers != null ? (Collection)this.diskContainers.stream().map(ImageDiskContainer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder diskContainers(Collection<ImageDiskContainer> diskContainers) {
            this.diskContainers = ImageDiskContainerListCopier.copy(diskContainers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskContainers(ImageDiskContainer ... diskContainers) {
            this.diskContainers(Arrays.asList(diskContainers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskContainers(Consumer<ImageDiskContainer.Builder> ... diskContainers) {
            this.diskContainers(Stream.of(diskContainers).map(c -> (ImageDiskContainer)((ImageDiskContainer.Builder)ImageDiskContainer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDiskContainers(Collection<ImageDiskContainer.BuilderImpl> diskContainers) {
            this.diskContainers = ImageDiskContainerListCopier.copyFromBuilder(diskContainers);
        }

        public final String getHypervisor() {
            return this.hypervisor;
        }

        @Override
        public final Builder hypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        public final void setHypervisor(String hypervisor) {
            this.hypervisor = hypervisor;
        }

        public final String getLicenseType() {
            return this.licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getRoleName() {
            return this.roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportImageRequest build() {
            return new ImportImageRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, ImportImageRequest> {
        public Builder architecture(String var1);

        public Builder clientData(ClientData var1);

        default public Builder clientData(Consumer<ClientData.Builder> clientData) {
            return this.clientData((ClientData)((ClientData.Builder)ClientData.builder().applyMutation(clientData)).build());
        }

        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder diskContainers(Collection<ImageDiskContainer> var1);

        public Builder diskContainers(ImageDiskContainer ... var1);

        public Builder diskContainers(Consumer<ImageDiskContainer.Builder> ... var1);

        public Builder hypervisor(String var1);

        public Builder licenseType(String var1);

        public Builder platform(String var1);

        public Builder roleName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

