/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FleetLaunchTemplateOverrides
implements ToCopyableBuilder<Builder, FleetLaunchTemplateOverrides> {
    private final String instanceType;
    private final String maxPrice;
    private final String subnetId;
    private final String availabilityZone;
    private final Double weightedCapacity;
    private final Double priority;

    private FleetLaunchTemplateOverrides(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.maxPrice = builder.maxPrice;
        this.subnetId = builder.subnetId;
        this.availabilityZone = builder.availabilityZone;
        this.weightedCapacity = builder.weightedCapacity;
        this.priority = builder.priority;
    }

    public InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeAsString() {
        return this.instanceType;
    }

    public String maxPrice() {
        return this.maxPrice;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Double weightedCapacity() {
        return this.weightedCapacity;
    }

    public Double priority() {
        return this.priority;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.weightedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetLaunchTemplateOverrides)) {
            return false;
        }
        FleetLaunchTemplateOverrides other = (FleetLaunchTemplateOverrides)obj;
        return Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.maxPrice(), other.maxPrice()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.weightedCapacity(), other.weightedCapacity()) && Objects.equals(this.priority(), other.priority());
    }

    public String toString() {
        return ToString.builder((String)"FleetLaunchTemplateOverrides").add("InstanceType", (Object)this.instanceTypeAsString()).add("MaxPrice", (Object)this.maxPrice()).add("SubnetId", (Object)this.subnetId()).add("AvailabilityZone", (Object)this.availabilityZone()).add("WeightedCapacity", (Object)this.weightedCapacity()).add("Priority", (Object)this.priority()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "MaxPrice": {
                return Optional.ofNullable(clazz.cast(this.maxPrice()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "WeightedCapacity": {
                return Optional.ofNullable(clazz.cast(this.weightedCapacity()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceType;
        private String maxPrice;
        private String subnetId;
        private String availabilityZone;
        private Double weightedCapacity;
        private Double priority;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetLaunchTemplateOverrides model) {
            this.instanceType(model.instanceType);
            this.maxPrice(model.maxPrice);
            this.subnetId(model.subnetId);
            this.availabilityZone(model.availabilityZone);
            this.weightedCapacity(model.weightedCapacity);
            this.priority(model.priority);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getMaxPrice() {
            return this.maxPrice;
        }

        @Override
        public final Builder maxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
            return this;
        }

        public final void setMaxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Double getWeightedCapacity() {
            return this.weightedCapacity;
        }

        @Override
        public final Builder weightedCapacity(Double weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
            return this;
        }

        public final void setWeightedCapacity(Double weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
        }

        public final Double getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Double priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Double priority) {
            this.priority = priority;
        }

        public FleetLaunchTemplateOverrides build() {
            return new FleetLaunchTemplateOverrides(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FleetLaunchTemplateOverrides> {
        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder maxPrice(String var1);

        public Builder subnetId(String var1);

        public Builder availabilityZone(String var1);

        public Builder weightedCapacity(Double var1);

        public Builder priority(Double var1);
    }
}

