/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.Vpc;
import software.amazon.awssdk.services.ec2.model.VpcListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpcsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVpcsResponse> {
    private final List<Vpc> vpcs;

    private DescribeVpcsResponse(BuilderImpl builder) {
        super(builder);
        this.vpcs = builder.vpcs;
    }

    public List<Vpc> vpcs() {
        return this.vpcs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcsResponse)) {
            return false;
        }
        DescribeVpcsResponse other = (DescribeVpcsResponse)((Object)obj);
        return Objects.equals(this.vpcs(), other.vpcs());
    }

    public String toString() {
        return ToString.builder((String)"DescribeVpcsResponse").add("Vpcs", this.vpcs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Vpcs": {
                return Optional.ofNullable(clazz.cast(this.vpcs()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<Vpc> vpcs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcsResponse model) {
            super(model);
            this.vpcs(model.vpcs);
        }

        public final Collection<Vpc.Builder> getVpcs() {
            return this.vpcs != null ? (Collection)this.vpcs.stream().map(Vpc::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcs(Collection<Vpc> vpcs) {
            this.vpcs = VpcListCopier.copy(vpcs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcs(Vpc ... vpcs) {
            this.vpcs(Arrays.asList(vpcs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcs(Consumer<Vpc.Builder> ... vpcs) {
            this.vpcs(Stream.of(vpcs).map(c -> (Vpc)((Vpc.Builder)Vpc.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpcs(Collection<Vpc.BuilderImpl> vpcs) {
            this.vpcs = VpcListCopier.copyFromBuilder(vpcs);
        }

        @Override
        public DescribeVpcsResponse build() {
            return new DescribeVpcsResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, DescribeVpcsResponse> {
        public Builder vpcs(Collection<Vpc> var1);

        public Builder vpcs(Vpc ... var1);

        public Builder vpcs(Consumer<Vpc.Builder> ... var1);
    }
}

