/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ConnectionNotification;
import software.amazon.awssdk.services.ec2.model.ConnectionNotificationSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVpcEndpointConnectionNotificationsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVpcEndpointConnectionNotificationsResponse> {
    private final List<ConnectionNotification> connectionNotificationSet;
    private final String nextToken;

    private DescribeVpcEndpointConnectionNotificationsResponse(BuilderImpl builder) {
        super(builder);
        this.connectionNotificationSet = builder.connectionNotificationSet;
        this.nextToken = builder.nextToken;
    }

    public List<ConnectionNotification> connectionNotificationSet() {
        return this.connectionNotificationSet;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionNotificationSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEndpointConnectionNotificationsResponse)) {
            return false;
        }
        DescribeVpcEndpointConnectionNotificationsResponse other = (DescribeVpcEndpointConnectionNotificationsResponse)((Object)obj);
        return Objects.equals(this.connectionNotificationSet(), other.connectionNotificationSet()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeVpcEndpointConnectionNotificationsResponse").add("ConnectionNotificationSet", this.connectionNotificationSet()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectionNotificationSet": {
                return Optional.ofNullable(clazz.cast(this.connectionNotificationSet()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<ConnectionNotification> connectionNotificationSet = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEndpointConnectionNotificationsResponse model) {
            super(model);
            this.connectionNotificationSet(model.connectionNotificationSet);
            this.nextToken(model.nextToken);
        }

        public final Collection<ConnectionNotification.Builder> getConnectionNotificationSet() {
            return this.connectionNotificationSet != null ? (Collection)this.connectionNotificationSet.stream().map(ConnectionNotification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder connectionNotificationSet(Collection<ConnectionNotification> connectionNotificationSet) {
            this.connectionNotificationSet = ConnectionNotificationSetCopier.copy(connectionNotificationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionNotificationSet(ConnectionNotification ... connectionNotificationSet) {
            this.connectionNotificationSet(Arrays.asList(connectionNotificationSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectionNotificationSet(Consumer<ConnectionNotification.Builder> ... connectionNotificationSet) {
            this.connectionNotificationSet(Stream.of(connectionNotificationSet).map(c -> (ConnectionNotification)((ConnectionNotification.Builder)ConnectionNotification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConnectionNotificationSet(Collection<ConnectionNotification.BuilderImpl> connectionNotificationSet) {
            this.connectionNotificationSet = ConnectionNotificationSetCopier.copyFromBuilder(connectionNotificationSet);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeVpcEndpointConnectionNotificationsResponse build() {
            return new DescribeVpcEndpointConnectionNotificationsResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, DescribeVpcEndpointConnectionNotificationsResponse> {
        public Builder connectionNotificationSet(Collection<ConnectionNotification> var1);

        public Builder connectionNotificationSet(ConnectionNotification ... var1);

        public Builder connectionNotificationSet(Consumer<ConnectionNotification.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

