/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.PrincipalIdFormat;
import software.amazon.awssdk.services.ec2.model.PrincipalIdFormatListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePrincipalIdFormatResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribePrincipalIdFormatResponse> {
    private final List<PrincipalIdFormat> principals;
    private final String nextToken;

    private DescribePrincipalIdFormatResponse(BuilderImpl builder) {
        super(builder);
        this.principals = builder.principals;
        this.nextToken = builder.nextToken;
    }

    public List<PrincipalIdFormat> principals() {
        return this.principals;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.principals());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePrincipalIdFormatResponse)) {
            return false;
        }
        DescribePrincipalIdFormatResponse other = (DescribePrincipalIdFormatResponse)((Object)obj);
        return Objects.equals(this.principals(), other.principals()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribePrincipalIdFormatResponse").add("Principals", this.principals()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Principals": {
                return Optional.ofNullable(clazz.cast(this.principals()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<PrincipalIdFormat> principals = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePrincipalIdFormatResponse model) {
            super(model);
            this.principals(model.principals);
            this.nextToken(model.nextToken);
        }

        public final Collection<PrincipalIdFormat.Builder> getPrincipals() {
            return this.principals != null ? (Collection)this.principals.stream().map(PrincipalIdFormat::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder principals(Collection<PrincipalIdFormat> principals) {
            this.principals = PrincipalIdFormatListCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(PrincipalIdFormat ... principals) {
            this.principals(Arrays.asList(principals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(Consumer<PrincipalIdFormat.Builder> ... principals) {
            this.principals(Stream.of(principals).map(c -> (PrincipalIdFormat)((PrincipalIdFormat.Builder)PrincipalIdFormat.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPrincipals(Collection<PrincipalIdFormat.BuilderImpl> principals) {
            this.principals = PrincipalIdFormatListCopier.copyFromBuilder(principals);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribePrincipalIdFormatResponse build() {
            return new DescribePrincipalIdFormatResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, DescribePrincipalIdFormatResponse> {
        public Builder principals(Collection<PrincipalIdFormat> var1);

        public Builder principals(PrincipalIdFormat ... var1);

        public Builder principals(Consumer<PrincipalIdFormat.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

