/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.InstanceCreditSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceCreditSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInstanceCreditSpecificationsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeInstanceCreditSpecificationsResponse> {
    private final List<InstanceCreditSpecification> instanceCreditSpecifications;
    private final String nextToken;

    private DescribeInstanceCreditSpecificationsResponse(BuilderImpl builder) {
        super(builder);
        this.instanceCreditSpecifications = builder.instanceCreditSpecifications;
        this.nextToken = builder.nextToken;
    }

    public List<InstanceCreditSpecification> instanceCreditSpecifications() {
        return this.instanceCreditSpecifications;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCreditSpecifications());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceCreditSpecificationsResponse)) {
            return false;
        }
        DescribeInstanceCreditSpecificationsResponse other = (DescribeInstanceCreditSpecificationsResponse)((Object)obj);
        return Objects.equals(this.instanceCreditSpecifications(), other.instanceCreditSpecifications()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeInstanceCreditSpecificationsResponse").add("InstanceCreditSpecifications", this.instanceCreditSpecifications()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceCreditSpecifications": {
                return Optional.ofNullable(clazz.cast(this.instanceCreditSpecifications()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<InstanceCreditSpecification> instanceCreditSpecifications = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceCreditSpecificationsResponse model) {
            super(model);
            this.instanceCreditSpecifications(model.instanceCreditSpecifications);
            this.nextToken(model.nextToken);
        }

        public final Collection<InstanceCreditSpecification.Builder> getInstanceCreditSpecifications() {
            return this.instanceCreditSpecifications != null ? (Collection)this.instanceCreditSpecifications.stream().map(InstanceCreditSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceCreditSpecifications(Collection<InstanceCreditSpecification> instanceCreditSpecifications) {
            this.instanceCreditSpecifications = InstanceCreditSpecificationListCopier.copy(instanceCreditSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceCreditSpecifications(InstanceCreditSpecification ... instanceCreditSpecifications) {
            this.instanceCreditSpecifications(Arrays.asList(instanceCreditSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceCreditSpecifications(Consumer<InstanceCreditSpecification.Builder> ... instanceCreditSpecifications) {
            this.instanceCreditSpecifications(Stream.of(instanceCreditSpecifications).map(c -> (InstanceCreditSpecification)((InstanceCreditSpecification.Builder)InstanceCreditSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceCreditSpecifications(Collection<InstanceCreditSpecification.BuilderImpl> instanceCreditSpecifications) {
            this.instanceCreditSpecifications = InstanceCreditSpecificationListCopier.copyFromBuilder(instanceCreditSpecifications);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeInstanceCreditSpecificationsResponse build() {
            return new DescribeInstanceCreditSpecificationsResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, DescribeInstanceCreditSpecificationsResponse> {
        public Builder instanceCreditSpecifications(Collection<InstanceCreditSpecification> var1);

        public Builder instanceCreditSpecifications(InstanceCreditSpecification ... var1);

        public Builder instanceCreditSpecifications(Consumer<InstanceCreditSpecification.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

