/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIdentityIdFormatRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeIdentityIdFormatRequest> {
    private final String principalArn;
    private final String resource;

    private DescribeIdentityIdFormatRequest(BuilderImpl builder) {
        super(builder);
        this.principalArn = builder.principalArn;
        this.resource = builder.resource;
    }

    public String principalArn() {
        return this.principalArn;
    }

    public String resource() {
        return this.resource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.principalArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIdentityIdFormatRequest)) {
            return false;
        }
        DescribeIdentityIdFormatRequest other = (DescribeIdentityIdFormatRequest)((Object)obj);
        return Objects.equals(this.principalArn(), other.principalArn()) && Objects.equals(this.resource(), other.resource());
    }

    public String toString() {
        return ToString.builder((String)"DescribeIdentityIdFormatRequest").add("PrincipalArn", (Object)this.principalArn()).add("Resource", (Object)this.resource()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrincipalArn": {
                return Optional.ofNullable(clazz.cast(this.principalArn()));
            }
            case "Resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String principalArn;
        private String resource;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIdentityIdFormatRequest model) {
            super(model);
            this.principalArn(model.principalArn);
            this.resource(model.resource);
        }

        public final String getPrincipalArn() {
            return this.principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        public final String getResource() {
            return this.resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeIdentityIdFormatRequest build() {
            return new DescribeIdentityIdFormatRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, DescribeIdentityIdFormatRequest> {
        public Builder principalArn(String var1);

        public Builder resource(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

