/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.FpgaImage;
import software.amazon.awssdk.services.ec2.model.FpgaImageListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFpgaImagesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeFpgaImagesResponse> {
    private final List<FpgaImage> fpgaImages;
    private final String nextToken;

    private DescribeFpgaImagesResponse(BuilderImpl builder) {
        super(builder);
        this.fpgaImages = builder.fpgaImages;
        this.nextToken = builder.nextToken;
    }

    public List<FpgaImage> fpgaImages() {
        return this.fpgaImages;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fpgaImages());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFpgaImagesResponse)) {
            return false;
        }
        DescribeFpgaImagesResponse other = (DescribeFpgaImagesResponse)((Object)obj);
        return Objects.equals(this.fpgaImages(), other.fpgaImages()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeFpgaImagesResponse").add("FpgaImages", this.fpgaImages()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FpgaImages": {
                return Optional.ofNullable(clazz.cast(this.fpgaImages()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<FpgaImage> fpgaImages = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFpgaImagesResponse model) {
            super(model);
            this.fpgaImages(model.fpgaImages);
            this.nextToken(model.nextToken);
        }

        public final Collection<FpgaImage.Builder> getFpgaImages() {
            return this.fpgaImages != null ? (Collection)this.fpgaImages.stream().map(FpgaImage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fpgaImages(Collection<FpgaImage> fpgaImages) {
            this.fpgaImages = FpgaImageListCopier.copy(fpgaImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fpgaImages(FpgaImage ... fpgaImages) {
            this.fpgaImages(Arrays.asList(fpgaImages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fpgaImages(Consumer<FpgaImage.Builder> ... fpgaImages) {
            this.fpgaImages(Stream.of(fpgaImages).map(c -> (FpgaImage)((FpgaImage.Builder)FpgaImage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFpgaImages(Collection<FpgaImage.BuilderImpl> fpgaImages) {
            this.fpgaImages = FpgaImageListCopier.copyFromBuilder(fpgaImages);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeFpgaImagesResponse build() {
            return new DescribeFpgaImagesResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, DescribeFpgaImagesResponse> {
        public Builder fpgaImages(Collection<FpgaImage> var1);

        public Builder fpgaImages(FpgaImage ... var1);

        public Builder fpgaImages(Consumer<FpgaImage.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

