/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.FleetEventType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFleetHistoryRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeFleetHistoryRequest> {
    private final String eventType;
    private final Integer maxResults;
    private final String nextToken;
    private final String fleetId;
    private final Instant startTime;

    private DescribeFleetHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.eventType = builder.eventType;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.fleetId = builder.fleetId;
        this.startTime = builder.startTime;
    }

    public FleetEventType eventType() {
        return FleetEventType.fromValue(this.eventType);
    }

    public String eventTypeAsString() {
        return this.eventType;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public String fleetId() {
        return this.fleetId;
    }

    public Instant startTime() {
        return this.startTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetHistoryRequest)) {
            return false;
        }
        DescribeFleetHistoryRequest other = (DescribeFleetHistoryRequest)((Object)obj);
        return Objects.equals(this.eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.startTime(), other.startTime());
    }

    public String toString() {
        return ToString.builder((String)"DescribeFleetHistoryRequest").add("EventType", (Object)this.eventTypeAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("FleetId", (Object)this.fleetId()).add("StartTime", (Object)this.startTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventType": {
                return Optional.ofNullable(clazz.cast(this.eventTypeAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String eventType;
        private Integer maxResults;
        private String nextToken;
        private String fleetId;
        private Instant startTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetHistoryRequest model) {
            super(model);
            this.eventType(model.eventType);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.fleetId(model.fleetId);
            this.startTime(model.startTime);
        }

        public final String getEventType() {
            return this.eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(FleetEventType eventType) {
            this.eventType(eventType.toString());
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFleetHistoryRequest build() {
            return new DescribeFleetHistoryRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, DescribeFleetHistoryRequest> {
        public Builder eventType(String var1);

        public Builder eventType(FleetEventType var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder fleetId(String var1);

        public Builder startTime(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

