/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CustomerGateway;
import software.amazon.awssdk.services.ec2.model.CustomerGatewayListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCustomerGatewaysResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeCustomerGatewaysResponse> {
    private final List<CustomerGateway> customerGateways;

    private DescribeCustomerGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.customerGateways = builder.customerGateways;
    }

    public List<CustomerGateway> customerGateways() {
        return this.customerGateways;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customerGateways());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomerGatewaysResponse)) {
            return false;
        }
        DescribeCustomerGatewaysResponse other = (DescribeCustomerGatewaysResponse)((Object)obj);
        return Objects.equals(this.customerGateways(), other.customerGateways());
    }

    public String toString() {
        return ToString.builder((String)"DescribeCustomerGatewaysResponse").add("CustomerGateways", this.customerGateways()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CustomerGateways": {
                return Optional.ofNullable(clazz.cast(this.customerGateways()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<CustomerGateway> customerGateways = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomerGatewaysResponse model) {
            super(model);
            this.customerGateways(model.customerGateways);
        }

        public final Collection<CustomerGateway.Builder> getCustomerGateways() {
            return this.customerGateways != null ? (Collection)this.customerGateways.stream().map(CustomerGateway::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder customerGateways(Collection<CustomerGateway> customerGateways) {
            this.customerGateways = CustomerGatewayListCopier.copy(customerGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerGateways(CustomerGateway ... customerGateways) {
            this.customerGateways(Arrays.asList(customerGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerGateways(Consumer<CustomerGateway.Builder> ... customerGateways) {
            this.customerGateways(Stream.of(customerGateways).map(c -> (CustomerGateway)((CustomerGateway.Builder)CustomerGateway.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCustomerGateways(Collection<CustomerGateway.BuilderImpl> customerGateways) {
            this.customerGateways = CustomerGatewayListCopier.copyFromBuilder(customerGateways);
        }

        @Override
        public DescribeCustomerGatewaysResponse build() {
            return new DescribeCustomerGatewaysResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, DescribeCustomerGatewaysResponse> {
        public Builder customerGateways(Collection<CustomerGateway> var1);

        public Builder customerGateways(CustomerGateway ... var1);

        public Builder customerGateways(Consumer<CustomerGateway.Builder> ... var1);
    }
}

