/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AccountAttributeName;
import software.amazon.awssdk.services.ec2.model.AccountAttributeNameStringListCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAccountAttributesRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeAccountAttributesRequest> {
    private final List<String> attributeNames;

    private DescribeAccountAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.attributeNames = builder.attributeNames;
    }

    public List<AccountAttributeName> attributeNames() {
        return TypeConverter.convert(this.attributeNames, AccountAttributeName::fromValue);
    }

    public List<String> attributeNamesAsStrings() {
        return this.attributeNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeNamesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountAttributesRequest)) {
            return false;
        }
        DescribeAccountAttributesRequest other = (DescribeAccountAttributesRequest)((Object)obj);
        return Objects.equals(this.attributeNamesAsStrings(), other.attributeNamesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAccountAttributesRequest").add("AttributeNames", this.attributeNamesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeNames": {
                return Optional.ofNullable(clazz.cast(this.attributeNamesAsStrings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<String> attributeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountAttributesRequest model) {
            super(model);
            this.attributeNamesWithStrings(model.attributeNames);
        }

        public final Collection<String> getAttributeNames() {
            return this.attributeNames;
        }

        @Override
        public final Builder attributeNamesWithStrings(Collection<String> attributeNames) {
            this.attributeNames = AccountAttributeNameStringListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNamesWithStrings(String ... attributeNames) {
            this.attributeNamesWithStrings(Arrays.asList(attributeNames));
            return this;
        }

        @Override
        public final Builder attributeNames(Collection<AccountAttributeName> attributeNames) {
            this.attributeNames = AccountAttributeNameStringListCopier.copyEnumToString(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(AccountAttributeName ... attributeNames) {
            this.attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AccountAttributeNameStringListCopier.copy(attributeNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAccountAttributesRequest build() {
            return new DescribeAccountAttributesRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, DescribeAccountAttributesRequest> {
        public Builder attributeNamesWithStrings(Collection<String> var1);

        public Builder attributeNamesWithStrings(String ... var1);

        public Builder attributeNames(Collection<AccountAttributeName> var1);

        public Builder attributeNames(AccountAttributeName ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

