/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponseErrorItem;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponseErrorSetCopier;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponseSuccessItem;
import software.amazon.awssdk.services.ec2.model.DeleteLaunchTemplateVersionsResponseSuccessSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteLaunchTemplateVersionsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DeleteLaunchTemplateVersionsResponse> {
    private final List<DeleteLaunchTemplateVersionsResponseSuccessItem> successfullyDeletedLaunchTemplateVersions;
    private final List<DeleteLaunchTemplateVersionsResponseErrorItem> unsuccessfullyDeletedLaunchTemplateVersions;

    private DeleteLaunchTemplateVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.successfullyDeletedLaunchTemplateVersions = builder.successfullyDeletedLaunchTemplateVersions;
        this.unsuccessfullyDeletedLaunchTemplateVersions = builder.unsuccessfullyDeletedLaunchTemplateVersions;
    }

    public List<DeleteLaunchTemplateVersionsResponseSuccessItem> successfullyDeletedLaunchTemplateVersions() {
        return this.successfullyDeletedLaunchTemplateVersions;
    }

    public List<DeleteLaunchTemplateVersionsResponseErrorItem> unsuccessfullyDeletedLaunchTemplateVersions() {
        return this.unsuccessfullyDeletedLaunchTemplateVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.successfullyDeletedLaunchTemplateVersions());
        hashCode = 31 * hashCode + Objects.hashCode(this.unsuccessfullyDeletedLaunchTemplateVersions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteLaunchTemplateVersionsResponse)) {
            return false;
        }
        DeleteLaunchTemplateVersionsResponse other = (DeleteLaunchTemplateVersionsResponse)((Object)obj);
        return Objects.equals(this.successfullyDeletedLaunchTemplateVersions(), other.successfullyDeletedLaunchTemplateVersions()) && Objects.equals(this.unsuccessfullyDeletedLaunchTemplateVersions(), other.unsuccessfullyDeletedLaunchTemplateVersions());
    }

    public String toString() {
        return ToString.builder((String)"DeleteLaunchTemplateVersionsResponse").add("SuccessfullyDeletedLaunchTemplateVersions", this.successfullyDeletedLaunchTemplateVersions()).add("UnsuccessfullyDeletedLaunchTemplateVersions", this.unsuccessfullyDeletedLaunchTemplateVersions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuccessfullyDeletedLaunchTemplateVersions": {
                return Optional.ofNullable(clazz.cast(this.successfullyDeletedLaunchTemplateVersions()));
            }
            case "UnsuccessfullyDeletedLaunchTemplateVersions": {
                return Optional.ofNullable(clazz.cast(this.unsuccessfullyDeletedLaunchTemplateVersions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<DeleteLaunchTemplateVersionsResponseSuccessItem> successfullyDeletedLaunchTemplateVersions = DefaultSdkAutoConstructList.getInstance();
        private List<DeleteLaunchTemplateVersionsResponseErrorItem> unsuccessfullyDeletedLaunchTemplateVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteLaunchTemplateVersionsResponse model) {
            super(model);
            this.successfullyDeletedLaunchTemplateVersions(model.successfullyDeletedLaunchTemplateVersions);
            this.unsuccessfullyDeletedLaunchTemplateVersions(model.unsuccessfullyDeletedLaunchTemplateVersions);
        }

        public final Collection<DeleteLaunchTemplateVersionsResponseSuccessItem.Builder> getSuccessfullyDeletedLaunchTemplateVersions() {
            return this.successfullyDeletedLaunchTemplateVersions != null ? (Collection)this.successfullyDeletedLaunchTemplateVersions.stream().map(DeleteLaunchTemplateVersionsResponseSuccessItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder successfullyDeletedLaunchTemplateVersions(Collection<DeleteLaunchTemplateVersionsResponseSuccessItem> successfullyDeletedLaunchTemplateVersions) {
            this.successfullyDeletedLaunchTemplateVersions = DeleteLaunchTemplateVersionsResponseSuccessSetCopier.copy(successfullyDeletedLaunchTemplateVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfullyDeletedLaunchTemplateVersions(DeleteLaunchTemplateVersionsResponseSuccessItem ... successfullyDeletedLaunchTemplateVersions) {
            this.successfullyDeletedLaunchTemplateVersions(Arrays.asList(successfullyDeletedLaunchTemplateVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfullyDeletedLaunchTemplateVersions(Consumer<DeleteLaunchTemplateVersionsResponseSuccessItem.Builder> ... successfullyDeletedLaunchTemplateVersions) {
            this.successfullyDeletedLaunchTemplateVersions(Stream.of(successfullyDeletedLaunchTemplateVersions).map(c -> (DeleteLaunchTemplateVersionsResponseSuccessItem)((DeleteLaunchTemplateVersionsResponseSuccessItem.Builder)DeleteLaunchTemplateVersionsResponseSuccessItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSuccessfullyDeletedLaunchTemplateVersions(Collection<DeleteLaunchTemplateVersionsResponseSuccessItem.BuilderImpl> successfullyDeletedLaunchTemplateVersions) {
            this.successfullyDeletedLaunchTemplateVersions = DeleteLaunchTemplateVersionsResponseSuccessSetCopier.copyFromBuilder(successfullyDeletedLaunchTemplateVersions);
        }

        public final Collection<DeleteLaunchTemplateVersionsResponseErrorItem.Builder> getUnsuccessfullyDeletedLaunchTemplateVersions() {
            return this.unsuccessfullyDeletedLaunchTemplateVersions != null ? (Collection)this.unsuccessfullyDeletedLaunchTemplateVersions.stream().map(DeleteLaunchTemplateVersionsResponseErrorItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder unsuccessfullyDeletedLaunchTemplateVersions(Collection<DeleteLaunchTemplateVersionsResponseErrorItem> unsuccessfullyDeletedLaunchTemplateVersions) {
            this.unsuccessfullyDeletedLaunchTemplateVersions = DeleteLaunchTemplateVersionsResponseErrorSetCopier.copy(unsuccessfullyDeletedLaunchTemplateVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfullyDeletedLaunchTemplateVersions(DeleteLaunchTemplateVersionsResponseErrorItem ... unsuccessfullyDeletedLaunchTemplateVersions) {
            this.unsuccessfullyDeletedLaunchTemplateVersions(Arrays.asList(unsuccessfullyDeletedLaunchTemplateVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessfullyDeletedLaunchTemplateVersions(Consumer<DeleteLaunchTemplateVersionsResponseErrorItem.Builder> ... unsuccessfullyDeletedLaunchTemplateVersions) {
            this.unsuccessfullyDeletedLaunchTemplateVersions(Stream.of(unsuccessfullyDeletedLaunchTemplateVersions).map(c -> (DeleteLaunchTemplateVersionsResponseErrorItem)((DeleteLaunchTemplateVersionsResponseErrorItem.Builder)DeleteLaunchTemplateVersionsResponseErrorItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUnsuccessfullyDeletedLaunchTemplateVersions(Collection<DeleteLaunchTemplateVersionsResponseErrorItem.BuilderImpl> unsuccessfullyDeletedLaunchTemplateVersions) {
            this.unsuccessfullyDeletedLaunchTemplateVersions = DeleteLaunchTemplateVersionsResponseErrorSetCopier.copyFromBuilder(unsuccessfullyDeletedLaunchTemplateVersions);
        }

        @Override
        public DeleteLaunchTemplateVersionsResponse build() {
            return new DeleteLaunchTemplateVersionsResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, DeleteLaunchTemplateVersionsResponse> {
        public Builder successfullyDeletedLaunchTemplateVersions(Collection<DeleteLaunchTemplateVersionsResponseSuccessItem> var1);

        public Builder successfullyDeletedLaunchTemplateVersions(DeleteLaunchTemplateVersionsResponseSuccessItem ... var1);

        public Builder successfullyDeletedLaunchTemplateVersions(Consumer<DeleteLaunchTemplateVersionsResponseSuccessItem.Builder> ... var1);

        public Builder unsuccessfullyDeletedLaunchTemplateVersions(Collection<DeleteLaunchTemplateVersionsResponseErrorItem> var1);

        public Builder unsuccessfullyDeletedLaunchTemplateVersions(DeleteLaunchTemplateVersionsResponseErrorItem ... var1);

        public Builder unsuccessfullyDeletedLaunchTemplateVersions(Consumer<DeleteLaunchTemplateVersionsResponseErrorItem.Builder> ... var1);
    }
}

