/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DhcpConfiguration;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.NewDhcpConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDhcpOptionsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateDhcpOptionsRequest> {
    private final List<DhcpConfiguration> dhcpConfigurations;

    private CreateDhcpOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.dhcpConfigurations = builder.dhcpConfigurations;
    }

    public List<DhcpConfiguration> dhcpConfigurations() {
        return this.dhcpConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dhcpConfigurations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDhcpOptionsRequest)) {
            return false;
        }
        CreateDhcpOptionsRequest other = (CreateDhcpOptionsRequest)((Object)obj);
        return Objects.equals(this.dhcpConfigurations(), other.dhcpConfigurations());
    }

    public String toString() {
        return ToString.builder((String)"CreateDhcpOptionsRequest").add("DhcpConfigurations", this.dhcpConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DhcpConfigurations": {
                return Optional.ofNullable(clazz.cast(this.dhcpConfigurations()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private List<DhcpConfiguration> dhcpConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDhcpOptionsRequest model) {
            super(model);
            this.dhcpConfigurations(model.dhcpConfigurations);
        }

        public final Collection<DhcpConfiguration.Builder> getDhcpConfigurations() {
            return this.dhcpConfigurations != null ? (Collection)this.dhcpConfigurations.stream().map(DhcpConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dhcpConfigurations(Collection<DhcpConfiguration> dhcpConfigurations) {
            this.dhcpConfigurations = NewDhcpConfigurationListCopier.copy(dhcpConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpConfigurations(DhcpConfiguration ... dhcpConfigurations) {
            this.dhcpConfigurations(Arrays.asList(dhcpConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpConfigurations(Consumer<DhcpConfiguration.Builder> ... dhcpConfigurations) {
            this.dhcpConfigurations(Stream.of(dhcpConfigurations).map(c -> (DhcpConfiguration)((DhcpConfiguration.Builder)DhcpConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDhcpConfigurations(Collection<DhcpConfiguration.BuilderImpl> dhcpConfigurations) {
            this.dhcpConfigurations = NewDhcpConfigurationListCopier.copyFromBuilder(dhcpConfigurations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDhcpOptionsRequest build() {
            return new CreateDhcpOptionsRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, CreateDhcpOptionsRequest> {
        public Builder dhcpConfigurations(Collection<DhcpConfiguration> var1);

        public Builder dhcpConfigurations(DhcpConfiguration ... var1);

        public Builder dhcpConfigurations(Consumer<DhcpConfiguration.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

