/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesListing;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesListingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelReservedInstancesListingResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CancelReservedInstancesListingResponse> {
    private final List<ReservedInstancesListing> reservedInstancesListings;

    private CancelReservedInstancesListingResponse(BuilderImpl builder) {
        super(builder);
        this.reservedInstancesListings = builder.reservedInstancesListings;
    }

    public List<ReservedInstancesListing> reservedInstancesListings() {
        return this.reservedInstancesListings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesListings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelReservedInstancesListingResponse)) {
            return false;
        }
        CancelReservedInstancesListingResponse other = (CancelReservedInstancesListingResponse)((Object)obj);
        return Objects.equals(this.reservedInstancesListings(), other.reservedInstancesListings());
    }

    public String toString() {
        return ToString.builder((String)"CancelReservedInstancesListingResponse").add("ReservedInstancesListings", this.reservedInstancesListings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedInstancesListings": {
                return Optional.ofNullable(clazz.cast(this.reservedInstancesListings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<ReservedInstancesListing> reservedInstancesListings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CancelReservedInstancesListingResponse model) {
            super(model);
            this.reservedInstancesListings(model.reservedInstancesListings);
        }

        public final Collection<ReservedInstancesListing.Builder> getReservedInstancesListings() {
            return this.reservedInstancesListings != null ? (Collection)this.reservedInstancesListings.stream().map(ReservedInstancesListing::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedInstancesListings(Collection<ReservedInstancesListing> reservedInstancesListings) {
            this.reservedInstancesListings = ReservedInstancesListingListCopier.copy(reservedInstancesListings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesListings(ReservedInstancesListing ... reservedInstancesListings) {
            this.reservedInstancesListings(Arrays.asList(reservedInstancesListings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesListings(Consumer<ReservedInstancesListing.Builder> ... reservedInstancesListings) {
            this.reservedInstancesListings(Stream.of(reservedInstancesListings).map(c -> (ReservedInstancesListing)((ReservedInstancesListing.Builder)ReservedInstancesListing.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReservedInstancesListings(Collection<ReservedInstancesListing.BuilderImpl> reservedInstancesListings) {
            this.reservedInstancesListings = ReservedInstancesListingListCopier.copyFromBuilder(reservedInstancesListings);
        }

        @Override
        public CancelReservedInstancesListingResponse build() {
            return new CancelReservedInstancesListingResponse(this);
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    CopyableBuilder<Builder, CancelReservedInstancesListingResponse> {
        public Builder reservedInstancesListings(Collection<ReservedInstancesListing> var1);

        public Builder reservedInstancesListings(ReservedInstancesListing ... var1);

        public Builder reservedInstancesListings(Consumer<ReservedInstancesListing.Builder> ... var1);
    }
}

