/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ec2.model.EbsBlockDevice;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BlockDeviceMapping
implements ToCopyableBuilder<Builder, BlockDeviceMapping> {
    private final String deviceName;
    private final String virtualName;
    private final EbsBlockDevice ebs;
    private final String noDevice;

    private BlockDeviceMapping(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.virtualName = builder.virtualName;
        this.ebs = builder.ebs;
        this.noDevice = builder.noDevice;
    }

    public String deviceName() {
        return this.deviceName;
    }

    public String virtualName() {
        return this.virtualName;
    }

    public EbsBlockDevice ebs() {
        return this.ebs;
    }

    public String noDevice() {
        return this.noDevice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebs());
        hashCode = 31 * hashCode + Objects.hashCode(this.noDevice());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockDeviceMapping)) {
            return false;
        }
        BlockDeviceMapping other = (BlockDeviceMapping)obj;
        return Objects.equals(this.deviceName(), other.deviceName()) && Objects.equals(this.virtualName(), other.virtualName()) && Objects.equals(this.ebs(), other.ebs()) && Objects.equals(this.noDevice(), other.noDevice());
    }

    public String toString() {
        return ToString.builder((String)"BlockDeviceMapping").add("DeviceName", (Object)this.deviceName()).add("VirtualName", (Object)this.virtualName()).add("Ebs", (Object)this.ebs()).add("NoDevice", (Object)this.noDevice()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
            case "VirtualName": {
                return Optional.ofNullable(clazz.cast(this.virtualName()));
            }
            case "Ebs": {
                return Optional.ofNullable(clazz.cast(this.ebs()));
            }
            case "NoDevice": {
                return Optional.ofNullable(clazz.cast(this.noDevice()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceName;
        private String virtualName;
        private EbsBlockDevice ebs;
        private String noDevice;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockDeviceMapping model) {
            this.deviceName(model.deviceName);
            this.virtualName(model.virtualName);
            this.ebs(model.ebs);
            this.noDevice(model.noDevice);
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getVirtualName() {
            return this.virtualName;
        }

        @Override
        public final Builder virtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        public final void setVirtualName(String virtualName) {
            this.virtualName = virtualName;
        }

        public final EbsBlockDevice.Builder getEbs() {
            return this.ebs != null ? this.ebs.toBuilder() : null;
        }

        @Override
        public final Builder ebs(EbsBlockDevice ebs) {
            this.ebs = ebs;
            return this;
        }

        public final void setEbs(EbsBlockDevice.BuilderImpl ebs) {
            this.ebs = ebs != null ? ebs.build() : null;
        }

        public final String getNoDevice() {
            return this.noDevice;
        }

        @Override
        public final Builder noDevice(String noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        public final void setNoDevice(String noDevice) {
            this.noDevice = noDevice;
        }

        public BlockDeviceMapping build() {
            return new BlockDeviceMapping(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BlockDeviceMapping> {
        public Builder deviceName(String var1);

        public Builder virtualName(String var1);

        public Builder ebs(EbsBlockDevice var1);

        default public Builder ebs(Consumer<EbsBlockDevice.Builder> ebs) {
            return this.ebs((EbsBlockDevice)((EbsBlockDevice.Builder)EbsBlockDevice.builder().applyMutation(ebs)).build());
        }

        public Builder noDevice(String var1);
    }
}

