/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateVpcCidrBlockRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, AssociateVpcCidrBlockRequest> {
    private final Boolean amazonProvidedIpv6CidrBlock;
    private final String cidrBlock;
    private final String vpcId;

    private AssociateVpcCidrBlockRequest(BuilderImpl builder) {
        super(builder);
        this.amazonProvidedIpv6CidrBlock = builder.amazonProvidedIpv6CidrBlock;
        this.cidrBlock = builder.cidrBlock;
        this.vpcId = builder.vpcId;
    }

    public Boolean amazonProvidedIpv6CidrBlock() {
        return this.amazonProvidedIpv6CidrBlock;
    }

    public String cidrBlock() {
        return this.cidrBlock;
    }

    public String vpcId() {
        return this.vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonProvidedIpv6CidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateVpcCidrBlockRequest)) {
            return false;
        }
        AssociateVpcCidrBlockRequest other = (AssociateVpcCidrBlockRequest)((Object)obj);
        return Objects.equals(this.amazonProvidedIpv6CidrBlock(), other.amazonProvidedIpv6CidrBlock()) && Objects.equals(this.cidrBlock(), other.cidrBlock()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public String toString() {
        return ToString.builder((String)"AssociateVpcCidrBlockRequest").add("AmazonProvidedIpv6CidrBlock", (Object)this.amazonProvidedIpv6CidrBlock()).add("CidrBlock", (Object)this.cidrBlock()).add("VpcId", (Object)this.vpcId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmazonProvidedIpv6CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.amazonProvidedIpv6CidrBlock()));
            }
            case "CidrBlock": {
                return Optional.ofNullable(clazz.cast(this.cidrBlock()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private Boolean amazonProvidedIpv6CidrBlock;
        private String cidrBlock;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateVpcCidrBlockRequest model) {
            super(model);
            this.amazonProvidedIpv6CidrBlock(model.amazonProvidedIpv6CidrBlock);
            this.cidrBlock(model.cidrBlock);
            this.vpcId(model.vpcId);
        }

        public final Boolean getAmazonProvidedIpv6CidrBlock() {
            return this.amazonProvidedIpv6CidrBlock;
        }

        @Override
        public final Builder amazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock) {
            this.amazonProvidedIpv6CidrBlock = amazonProvidedIpv6CidrBlock;
            return this;
        }

        public final void setAmazonProvidedIpv6CidrBlock(Boolean amazonProvidedIpv6CidrBlock) {
            this.amazonProvidedIpv6CidrBlock = amazonProvidedIpv6CidrBlock;
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateVpcCidrBlockRequest build() {
            return new AssociateVpcCidrBlockRequest(this);
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    CopyableBuilder<Builder, AssociateVpcCidrBlockRequest> {
        public Builder amazonProvidedIpv6CidrBlock(Boolean var1);

        public Builder cidrBlock(String var1);

        public Builder vpcId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

