/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.ResetSnapshotAttributeRequest;

public class ResetSnapshotAttributeRequestMarshaller
implements Marshaller<Request<ResetSnapshotAttributeRequest>, ResetSnapshotAttributeRequest> {
    public Request<ResetSnapshotAttributeRequest> marshall(ResetSnapshotAttributeRequest resetSnapshotAttributeRequest) {
        if (resetSnapshotAttributeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)resetSnapshotAttributeRequest, "Ec2Client");
        request.addParameter("Action", "ResetSnapshotAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (resetSnapshotAttributeRequest.attributeAsString() != null) {
            request.addParameter("Attribute", StringConversion.fromString((String)resetSnapshotAttributeRequest.attributeAsString()));
        }
        if (resetSnapshotAttributeRequest.snapshotId() != null) {
            request.addParameter("SnapshotId", StringConversion.fromString((String)resetSnapshotAttributeRequest.snapshotId()));
        }
        return request;
    }
}

