/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.ClassicLoadBalancer;
import software.amazon.awssdk.services.ec2.model.ClassicLoadBalancersConfig;
import software.amazon.awssdk.services.ec2.model.EbsBlockDevice;
import software.amazon.awssdk.services.ec2.model.FleetLaunchTemplateSpecification;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6Address;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateConfig;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateOverrides;
import software.amazon.awssdk.services.ec2.model.LoadBalancersConfig;
import software.amazon.awssdk.services.ec2.model.PrivateIpAddressSpecification;
import software.amazon.awssdk.services.ec2.model.RequestSpotFleetRequest;
import software.amazon.awssdk.services.ec2.model.SpotFleetLaunchSpecification;
import software.amazon.awssdk.services.ec2.model.SpotFleetMonitoring;
import software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfigData;
import software.amazon.awssdk.services.ec2.model.SpotFleetTagSpecification;
import software.amazon.awssdk.services.ec2.model.SpotPlacement;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TargetGroup;
import software.amazon.awssdk.services.ec2.model.TargetGroupsConfig;

public class RequestSpotFleetRequestMarshaller
implements Marshaller<Request<RequestSpotFleetRequest>, RequestSpotFleetRequest> {
    /*
     * Could not resolve type clashes
     */
    public Request<RequestSpotFleetRequest> marshall(RequestSpotFleetRequest requestSpotFleetRequest) {
        if (requestSpotFleetRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)requestSpotFleetRequest, "Ec2Client");
        request.addParameter("Action", "RequestSpotFleet");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SpotFleetRequestConfigData spotFleetRequestConfig = requestSpotFleetRequest.spotFleetRequestConfig();
        if (spotFleetRequestConfig != null) {
            LoadBalancersConfig loadBalancersConfig;
            List<LaunchTemplateConfig> spotFleetRequestConfigDataLaunchTemplateConfigsList;
            Object spotFleetLaunchSpecificationNetworkInterfacesList;
            List<SpotFleetLaunchSpecification> spotFleetRequestConfigDataLaunchSpecificationsList;
            if (spotFleetRequestConfig.allocationStrategyAsString() != null) {
                request.addParameter("SpotFleetRequestConfig.AllocationStrategy", StringConversion.fromString((String)spotFleetRequestConfig.allocationStrategyAsString()));
            }
            if (spotFleetRequestConfig.onDemandAllocationStrategyAsString() != null) {
                request.addParameter("SpotFleetRequestConfig.OnDemandAllocationStrategy", StringConversion.fromString((String)spotFleetRequestConfig.onDemandAllocationStrategyAsString()));
            }
            if (spotFleetRequestConfig.clientToken() != null) {
                request.addParameter("SpotFleetRequestConfig.ClientToken", StringConversion.fromString((String)spotFleetRequestConfig.clientToken()));
            }
            if (spotFleetRequestConfig.excessCapacityTerminationPolicyAsString() != null) {
                request.addParameter("SpotFleetRequestConfig.ExcessCapacityTerminationPolicy", StringConversion.fromString((String)spotFleetRequestConfig.excessCapacityTerminationPolicyAsString()));
            }
            if (spotFleetRequestConfig.fulfilledCapacity() != null) {
                request.addParameter("SpotFleetRequestConfig.FulfilledCapacity", StringConversion.fromDouble((Double)spotFleetRequestConfig.fulfilledCapacity()));
            }
            if (spotFleetRequestConfig.onDemandFulfilledCapacity() != null) {
                request.addParameter("SpotFleetRequestConfig.OnDemandFulfilledCapacity", StringConversion.fromDouble((Double)spotFleetRequestConfig.onDemandFulfilledCapacity()));
            }
            if (spotFleetRequestConfig.iamFleetRole() != null) {
                request.addParameter("SpotFleetRequestConfig.IamFleetRole", StringConversion.fromString((String)spotFleetRequestConfig.iamFleetRole()));
            }
            if (!(spotFleetRequestConfigDataLaunchSpecificationsList = spotFleetRequestConfig.launchSpecifications()).isEmpty() || !(spotFleetRequestConfigDataLaunchSpecificationsList instanceof SdkAutoConstructList)) {
                int launchSpecificationsListIndex = 1;
                for (Object spotFleetRequestConfigDataLaunchSpecificationsListValue : spotFleetRequestConfigDataLaunchSpecificationsList) {
                    List<SpotFleetTagSpecification> spotFleetLaunchSpecificationTagSpecificationsList;
                    SpotPlacement placement;
                    SpotFleetMonitoring monitoring;
                    IamInstanceProfileSpecification iamInstanceProfile;
                    List<BlockDeviceMapping> spotFleetLaunchSpecificationBlockDeviceMappingsList;
                    List<GroupIdentifier> spotFleetLaunchSpecificationSecurityGroupsList = ((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).securityGroups();
                    if (!spotFleetLaunchSpecificationSecurityGroupsList.isEmpty() || !(spotFleetLaunchSpecificationSecurityGroupsList instanceof SdkAutoConstructList)) {
                        int securityGroupsListIndex = 1;
                        for (Object spotFleetLaunchSpecificationSecurityGroupsListValue : spotFleetLaunchSpecificationSecurityGroupsList) {
                            if (((GroupIdentifier)spotFleetLaunchSpecificationSecurityGroupsListValue).groupName() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".GroupSet." + securityGroupsListIndex + ".GroupName", StringConversion.fromString((String)((GroupIdentifier)spotFleetLaunchSpecificationSecurityGroupsListValue).groupName()));
                            }
                            if (((GroupIdentifier)spotFleetLaunchSpecificationSecurityGroupsListValue).groupId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".GroupSet." + securityGroupsListIndex + ".GroupId", StringConversion.fromString((String)((GroupIdentifier)spotFleetLaunchSpecificationSecurityGroupsListValue).groupId()));
                            }
                            ++securityGroupsListIndex;
                        }
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).addressingType() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".AddressingType", StringConversion.fromString((String)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).addressingType()));
                    }
                    if (!(spotFleetLaunchSpecificationBlockDeviceMappingsList = ((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).blockDeviceMappings()).isEmpty() || !(spotFleetLaunchSpecificationBlockDeviceMappingsList instanceof SdkAutoConstructList)) {
                        Object spotFleetLaunchSpecificationSecurityGroupsListValue;
                        int blockDeviceMappingsListIndex = 1;
                        spotFleetLaunchSpecificationSecurityGroupsListValue = spotFleetLaunchSpecificationBlockDeviceMappingsList.iterator();
                        while (spotFleetLaunchSpecificationSecurityGroupsListValue.hasNext()) {
                            EbsBlockDevice ebs;
                            BlockDeviceMapping spotFleetLaunchSpecificationBlockDeviceMappingsListValue = (BlockDeviceMapping)spotFleetLaunchSpecificationSecurityGroupsListValue.next();
                            if (spotFleetLaunchSpecificationBlockDeviceMappingsListValue.deviceName() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringConversion.fromString((String)spotFleetLaunchSpecificationBlockDeviceMappingsListValue.deviceName()));
                            }
                            if (spotFleetLaunchSpecificationBlockDeviceMappingsListValue.virtualName() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringConversion.fromString((String)spotFleetLaunchSpecificationBlockDeviceMappingsListValue.virtualName()));
                            }
                            if ((ebs = spotFleetLaunchSpecificationBlockDeviceMappingsListValue.ebs()) != null) {
                                if (ebs.encrypted() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringConversion.fromBoolean((Boolean)ebs.encrypted()));
                                }
                                if (ebs.deleteOnTermination() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringConversion.fromBoolean((Boolean)ebs.deleteOnTermination()));
                                }
                                if (ebs.iops() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringConversion.fromInteger((Integer)ebs.iops()));
                                }
                                if (ebs.kmsKeyId() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.KmsKeyId", StringConversion.fromString((String)ebs.kmsKeyId()));
                                }
                                if (ebs.snapshotId() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringConversion.fromString((String)ebs.snapshotId()));
                                }
                                if (ebs.volumeSize() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringConversion.fromInteger((Integer)ebs.volumeSize()));
                                }
                                if (ebs.volumeTypeAsString() != null) {
                                    request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringConversion.fromString((String)ebs.volumeTypeAsString()));
                                }
                            }
                            if (spotFleetLaunchSpecificationBlockDeviceMappingsListValue.noDevice() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringConversion.fromString((String)spotFleetLaunchSpecificationBlockDeviceMappingsListValue.noDevice()));
                            }
                            ++blockDeviceMappingsListIndex;
                        }
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).ebsOptimized() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".EbsOptimized", StringConversion.fromBoolean((Boolean)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).ebsOptimized()));
                    }
                    if ((iamInstanceProfile = ((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).iamInstanceProfile()) != null) {
                        if (iamInstanceProfile.arn() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".IamInstanceProfile.Arn", StringConversion.fromString((String)iamInstanceProfile.arn()));
                        }
                        if (iamInstanceProfile.name() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".IamInstanceProfile.Name", StringConversion.fromString((String)iamInstanceProfile.name()));
                        }
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).imageId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".ImageId", StringConversion.fromString((String)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).imageId()));
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).instanceTypeAsString() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".InstanceType", StringConversion.fromString((String)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).instanceTypeAsString()));
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).kernelId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".KernelId", StringConversion.fromString((String)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).kernelId()));
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).keyName() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".KeyName", StringConversion.fromString((String)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).keyName()));
                    }
                    if ((monitoring = ((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).monitoring()) != null && monitoring.enabled() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Monitoring.Enabled", StringConversion.fromBoolean((Boolean)monitoring.enabled()));
                    }
                    if (!(spotFleetLaunchSpecificationNetworkInterfacesList = ((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).networkInterfaces()).isEmpty() || !(spotFleetLaunchSpecificationNetworkInterfacesList instanceof SdkAutoConstructList)) {
                        int networkInterfacesListIndex = 1;
                        Iterator iterator = spotFleetLaunchSpecificationNetworkInterfacesList.iterator();
                        while (iterator.hasNext()) {
                            List<PrivateIpAddressSpecification> instanceNetworkInterfaceSpecificationPrivateIpAddressesList;
                            List<InstanceIpv6Address> instanceNetworkInterfaceSpecificationIpv6AddressesList;
                            List<String> instanceNetworkInterfaceSpecificationGroupsList;
                            InstanceNetworkInterfaceSpecification spotFleetLaunchSpecificationNetworkInterfacesListValue = (InstanceNetworkInterfaceSpecification)iterator.next();
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.associatePublicIpAddress() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringConversion.fromBoolean((Boolean)spotFleetLaunchSpecificationNetworkInterfacesListValue.associatePublicIpAddress()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.deleteOnTermination() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".DeleteOnTermination", StringConversion.fromBoolean((Boolean)spotFleetLaunchSpecificationNetworkInterfacesListValue.deleteOnTermination()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.description() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".Description", StringConversion.fromString((String)spotFleetLaunchSpecificationNetworkInterfacesListValue.description()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.deviceIndex() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".DeviceIndex", StringConversion.fromInteger((Integer)spotFleetLaunchSpecificationNetworkInterfacesListValue.deviceIndex()));
                            }
                            if (!(instanceNetworkInterfaceSpecificationGroupsList = spotFleetLaunchSpecificationNetworkInterfacesListValue.groups()).isEmpty() || !(instanceNetworkInterfaceSpecificationGroupsList instanceof SdkAutoConstructList)) {
                                int groupsListIndex = 1;
                                for (Object instanceNetworkInterfaceSpecificationGroupsListValue : instanceNetworkInterfaceSpecificationGroupsList) {
                                    if (instanceNetworkInterfaceSpecificationGroupsListValue != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".SecurityGroupId." + groupsListIndex, StringConversion.fromString((String)instanceNetworkInterfaceSpecificationGroupsListValue));
                                    }
                                    ++groupsListIndex;
                                }
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.ipv6AddressCount() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".Ipv6AddressCount", StringConversion.fromInteger((Integer)spotFleetLaunchSpecificationNetworkInterfacesListValue.ipv6AddressCount()));
                            }
                            if (!(instanceNetworkInterfaceSpecificationIpv6AddressesList = spotFleetLaunchSpecificationNetworkInterfacesListValue.ipv6Addresses()).isEmpty() || !(instanceNetworkInterfaceSpecificationIpv6AddressesList instanceof SdkAutoConstructList)) {
                                Object instanceNetworkInterfaceSpecificationGroupsListValue;
                                int ipv6AddressesListIndex = 1;
                                instanceNetworkInterfaceSpecificationGroupsListValue = instanceNetworkInterfaceSpecificationIpv6AddressesList.iterator();
                                while (instanceNetworkInterfaceSpecificationGroupsListValue.hasNext()) {
                                    InstanceIpv6Address instanceNetworkInterfaceSpecificationIpv6AddressesListValue = (InstanceIpv6Address)instanceNetworkInterfaceSpecificationGroupsListValue.next();
                                    if (instanceNetworkInterfaceSpecificationIpv6AddressesListValue.ipv6Address() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".Ipv6Addresses." + ipv6AddressesListIndex + ".Ipv6Address", StringConversion.fromString((String)instanceNetworkInterfaceSpecificationIpv6AddressesListValue.ipv6Address()));
                                    }
                                    ++ipv6AddressesListIndex;
                                }
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.networkInterfaceId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".NetworkInterfaceId", StringConversion.fromString((String)spotFleetLaunchSpecificationNetworkInterfacesListValue.networkInterfaceId()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.privateIpAddress() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".PrivateIpAddress", StringConversion.fromString((String)spotFleetLaunchSpecificationNetworkInterfacesListValue.privateIpAddress()));
                            }
                            if (!(instanceNetworkInterfaceSpecificationPrivateIpAddressesList = spotFleetLaunchSpecificationNetworkInterfacesListValue.privateIpAddresses()).isEmpty() || !(instanceNetworkInterfaceSpecificationPrivateIpAddressesList instanceof SdkAutoConstructList)) {
                                int privateIpAddressesListIndex = 1;
                                for (PrivateIpAddressSpecification instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue : instanceNetworkInterfaceSpecificationPrivateIpAddressesList) {
                                    if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.primary() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringConversion.fromBoolean((Boolean)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.primary()));
                                    }
                                    if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.privateIpAddress() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringConversion.fromString((String)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.privateIpAddress()));
                                    }
                                    ++privateIpAddressesListIndex;
                                }
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.secondaryPrivateIpAddressCount() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringConversion.fromInteger((Integer)spotFleetLaunchSpecificationNetworkInterfacesListValue.secondaryPrivateIpAddressCount()));
                            }
                            if (spotFleetLaunchSpecificationNetworkInterfacesListValue.subnetId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".NetworkInterfaceSet." + networkInterfacesListIndex + ".SubnetId", StringConversion.fromString((String)spotFleetLaunchSpecificationNetworkInterfacesListValue.subnetId()));
                            }
                            ++networkInterfacesListIndex;
                        }
                    }
                    if ((placement = ((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).placement()) != null) {
                        if (placement.availabilityZone() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Placement.AvailabilityZone", StringConversion.fromString((String)placement.availabilityZone()));
                        }
                        if (placement.groupName() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Placement.GroupName", StringConversion.fromString((String)placement.groupName()));
                        }
                        if (placement.tenancyAsString() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".Placement.Tenancy", StringConversion.fromString((String)placement.tenancyAsString()));
                        }
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).ramdiskId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".RamdiskId", StringConversion.fromString((String)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).ramdiskId()));
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).spotPrice() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".SpotPrice", StringConversion.fromString((String)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).spotPrice()));
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).subnetId() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".SubnetId", StringConversion.fromString((String)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).subnetId()));
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).userData() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".UserData", StringConversion.fromString((String)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).userData()));
                    }
                    if (((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).weightedCapacity() != null) {
                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".WeightedCapacity", StringConversion.fromDouble((Double)((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).weightedCapacity()));
                    }
                    if (!(spotFleetLaunchSpecificationTagSpecificationsList = ((SpotFleetLaunchSpecification)spotFleetRequestConfigDataLaunchSpecificationsListValue).tagSpecifications()).isEmpty() || !(spotFleetLaunchSpecificationTagSpecificationsList instanceof SdkAutoConstructList)) {
                        int tagSpecificationsListIndex = 1;
                        for (SpotFleetTagSpecification spotFleetLaunchSpecificationTagSpecificationsListValue : spotFleetLaunchSpecificationTagSpecificationsList) {
                            List<Tag> spotFleetTagSpecificationTagsList;
                            if (spotFleetLaunchSpecificationTagSpecificationsListValue.resourceTypeAsString() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".TagSpecificationSet." + tagSpecificationsListIndex + ".ResourceType", StringConversion.fromString((String)spotFleetLaunchSpecificationTagSpecificationsListValue.resourceTypeAsString()));
                            }
                            if (!(spotFleetTagSpecificationTagsList = spotFleetLaunchSpecificationTagSpecificationsListValue.tags()).isEmpty() || !(spotFleetTagSpecificationTagsList instanceof SdkAutoConstructList)) {
                                int tagsListIndex = 1;
                                for (Tag spotFleetTagSpecificationTagsListValue : spotFleetTagSpecificationTagsList) {
                                    if (spotFleetTagSpecificationTagsListValue.key() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".TagSpecificationSet." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)spotFleetTagSpecificationTagsListValue.key()));
                                    }
                                    if (spotFleetTagSpecificationTagsListValue.value() != null) {
                                        request.addParameter("SpotFleetRequestConfig.LaunchSpecifications." + launchSpecificationsListIndex + ".TagSpecificationSet." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)spotFleetTagSpecificationTagsListValue.value()));
                                    }
                                    ++tagsListIndex;
                                }
                            }
                            ++tagSpecificationsListIndex;
                        }
                    }
                    ++launchSpecificationsListIndex;
                }
            }
            if (!(spotFleetRequestConfigDataLaunchTemplateConfigsList = spotFleetRequestConfig.launchTemplateConfigs()).isEmpty() || !(spotFleetRequestConfigDataLaunchTemplateConfigsList instanceof SdkAutoConstructList)) {
                int launchTemplateConfigsListIndex = 1;
                for (LaunchTemplateConfig spotFleetRequestConfigDataLaunchTemplateConfigsListValue : spotFleetRequestConfigDataLaunchTemplateConfigsList) {
                    Object launchTemplateConfigOverridesList;
                    FleetLaunchTemplateSpecification launchTemplateSpecification = spotFleetRequestConfigDataLaunchTemplateConfigsListValue.launchTemplateSpecification();
                    if (launchTemplateSpecification != null) {
                        if (launchTemplateSpecification.launchTemplateId() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.LaunchTemplateId", StringConversion.fromString((String)launchTemplateSpecification.launchTemplateId()));
                        }
                        if (launchTemplateSpecification.launchTemplateName() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.LaunchTemplateName", StringConversion.fromString((String)launchTemplateSpecification.launchTemplateName()));
                        }
                        if (launchTemplateSpecification.version() != null) {
                            request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.Version", StringConversion.fromString((String)launchTemplateSpecification.version()));
                        }
                    }
                    if (!(launchTemplateConfigOverridesList = spotFleetRequestConfigDataLaunchTemplateConfigsListValue.overrides()).isEmpty() || !(launchTemplateConfigOverridesList instanceof SdkAutoConstructList)) {
                        int overridesListIndex = 1;
                        spotFleetLaunchSpecificationNetworkInterfacesList = launchTemplateConfigOverridesList.iterator();
                        while (spotFleetLaunchSpecificationNetworkInterfacesList.hasNext()) {
                            LaunchTemplateOverrides launchTemplateConfigOverridesListValue = spotFleetLaunchSpecificationNetworkInterfacesList.next();
                            if (launchTemplateConfigOverridesListValue.instanceTypeAsString() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceType", StringConversion.fromString((String)launchTemplateConfigOverridesListValue.instanceTypeAsString()));
                            }
                            if (launchTemplateConfigOverridesListValue.spotPrice() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".SpotPrice", StringConversion.fromString((String)launchTemplateConfigOverridesListValue.spotPrice()));
                            }
                            if (launchTemplateConfigOverridesListValue.subnetId() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".SubnetId", StringConversion.fromString((String)launchTemplateConfigOverridesListValue.subnetId()));
                            }
                            if (launchTemplateConfigOverridesListValue.availabilityZone() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".AvailabilityZone", StringConversion.fromString((String)launchTemplateConfigOverridesListValue.availabilityZone()));
                            }
                            if (launchTemplateConfigOverridesListValue.weightedCapacity() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".WeightedCapacity", StringConversion.fromDouble((Double)launchTemplateConfigOverridesListValue.weightedCapacity()));
                            }
                            if (launchTemplateConfigOverridesListValue.priority() != null) {
                                request.addParameter("SpotFleetRequestConfig.LaunchTemplateConfigs." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Priority", StringConversion.fromDouble((Double)launchTemplateConfigOverridesListValue.priority()));
                            }
                            ++overridesListIndex;
                        }
                    }
                    ++launchTemplateConfigsListIndex;
                }
            }
            if (spotFleetRequestConfig.spotPrice() != null) {
                request.addParameter("SpotFleetRequestConfig.SpotPrice", StringConversion.fromString((String)spotFleetRequestConfig.spotPrice()));
            }
            if (spotFleetRequestConfig.targetCapacity() != null) {
                request.addParameter("SpotFleetRequestConfig.TargetCapacity", StringConversion.fromInteger((Integer)spotFleetRequestConfig.targetCapacity()));
            }
            if (spotFleetRequestConfig.onDemandTargetCapacity() != null) {
                request.addParameter("SpotFleetRequestConfig.OnDemandTargetCapacity", StringConversion.fromInteger((Integer)spotFleetRequestConfig.onDemandTargetCapacity()));
            }
            if (spotFleetRequestConfig.terminateInstancesWithExpiration() != null) {
                request.addParameter("SpotFleetRequestConfig.TerminateInstancesWithExpiration", StringConversion.fromBoolean((Boolean)spotFleetRequestConfig.terminateInstancesWithExpiration()));
            }
            if (spotFleetRequestConfig.typeAsString() != null) {
                request.addParameter("SpotFleetRequestConfig.Type", StringConversion.fromString((String)spotFleetRequestConfig.typeAsString()));
            }
            if (spotFleetRequestConfig.validFrom() != null) {
                request.addParameter("SpotFleetRequestConfig.ValidFrom", StringConversion.fromInstant((Instant)spotFleetRequestConfig.validFrom()));
            }
            if (spotFleetRequestConfig.validUntil() != null) {
                request.addParameter("SpotFleetRequestConfig.ValidUntil", StringConversion.fromInstant((Instant)spotFleetRequestConfig.validUntil()));
            }
            if (spotFleetRequestConfig.replaceUnhealthyInstances() != null) {
                request.addParameter("SpotFleetRequestConfig.ReplaceUnhealthyInstances", StringConversion.fromBoolean((Boolean)spotFleetRequestConfig.replaceUnhealthyInstances()));
            }
            if (spotFleetRequestConfig.instanceInterruptionBehaviorAsString() != null) {
                request.addParameter("SpotFleetRequestConfig.InstanceInterruptionBehavior", StringConversion.fromString((String)spotFleetRequestConfig.instanceInterruptionBehaviorAsString()));
            }
            if ((loadBalancersConfig = spotFleetRequestConfig.loadBalancersConfig()) != null) {
                List<TargetGroup> targetGroupsConfigTargetGroupsList;
                TargetGroupsConfig targetGroupsConfig;
                List<ClassicLoadBalancer> classicLoadBalancersConfigClassicLoadBalancersList;
                ClassicLoadBalancersConfig classicLoadBalancersConfig = loadBalancersConfig.classicLoadBalancersConfig();
                if (!(classicLoadBalancersConfig == null || (classicLoadBalancersConfigClassicLoadBalancersList = classicLoadBalancersConfig.classicLoadBalancers()).isEmpty() && classicLoadBalancersConfigClassicLoadBalancersList instanceof SdkAutoConstructList)) {
                    int classicLoadBalancersListIndex = 1;
                    for (ClassicLoadBalancer classicLoadBalancersConfigClassicLoadBalancersListValue : classicLoadBalancersConfigClassicLoadBalancersList) {
                        if (classicLoadBalancersConfigClassicLoadBalancersListValue.name() != null) {
                            request.addParameter("SpotFleetRequestConfig.LoadBalancersConfig.ClassicLoadBalancersConfig.ClassicLoadBalancers." + classicLoadBalancersListIndex + ".Name", StringConversion.fromString((String)classicLoadBalancersConfigClassicLoadBalancersListValue.name()));
                        }
                        ++classicLoadBalancersListIndex;
                    }
                }
                if (!((targetGroupsConfig = loadBalancersConfig.targetGroupsConfig()) == null || (targetGroupsConfigTargetGroupsList = targetGroupsConfig.targetGroups()).isEmpty() && targetGroupsConfigTargetGroupsList instanceof SdkAutoConstructList)) {
                    int targetGroupsListIndex = 1;
                    for (TargetGroup targetGroupsConfigTargetGroupsListValue : targetGroupsConfigTargetGroupsList) {
                        if (targetGroupsConfigTargetGroupsListValue.arn() != null) {
                            request.addParameter("SpotFleetRequestConfig.LoadBalancersConfig.TargetGroupsConfig.TargetGroups." + targetGroupsListIndex + ".Arn", StringConversion.fromString((String)targetGroupsConfigTargetGroupsListValue.arn()));
                        }
                        ++targetGroupsListIndex;
                    }
                }
            }
            if (spotFleetRequestConfig.instancePoolsToUseCount() != null) {
                request.addParameter("SpotFleetRequestConfig.InstancePoolsToUseCount", StringConversion.fromInteger((Integer)spotFleetRequestConfig.instancePoolsToUseCount()));
            }
        }
        return request;
    }
}

