/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.RebootInstancesRequest;

public class RebootInstancesRequestMarshaller
implements Marshaller<Request<RebootInstancesRequest>, RebootInstancesRequest> {
    public Request<RebootInstancesRequest> marshall(RebootInstancesRequest rebootInstancesRequest) {
        if (rebootInstancesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)rebootInstancesRequest, "Ec2Client");
        request.addParameter("Action", "RebootInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> rebootInstancesRequestInstanceIdsList = rebootInstancesRequest.instanceIds();
        if (!rebootInstancesRequestInstanceIdsList.isEmpty() || !(rebootInstancesRequestInstanceIdsList instanceof SdkAutoConstructList)) {
            int instanceIdsListIndex = 1;
            for (String rebootInstancesRequestInstanceIdsListValue : rebootInstancesRequestInstanceIdsList) {
                if (rebootInstancesRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringConversion.fromString((String)rebootInstancesRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        return request;
    }
}

