/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.PurchaseRequest;
import software.amazon.awssdk.services.ec2.model.PurchaseScheduledInstancesRequest;

public class PurchaseScheduledInstancesRequestMarshaller
implements Marshaller<Request<PurchaseScheduledInstancesRequest>, PurchaseScheduledInstancesRequest> {
    public Request<PurchaseScheduledInstancesRequest> marshall(PurchaseScheduledInstancesRequest purchaseScheduledInstancesRequest) {
        if (purchaseScheduledInstancesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)purchaseScheduledInstancesRequest, "Ec2Client");
        request.addParameter("Action", "PurchaseScheduledInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)purchaseScheduledInstancesRequest.clientToken()));
        List<PurchaseRequest> purchaseScheduledInstancesRequestPurchaseRequestsList = purchaseScheduledInstancesRequest.purchaseRequests();
        if (!purchaseScheduledInstancesRequestPurchaseRequestsList.isEmpty() || !(purchaseScheduledInstancesRequestPurchaseRequestsList instanceof SdkAutoConstructList)) {
            int purchaseRequestsListIndex = 1;
            for (PurchaseRequest purchaseScheduledInstancesRequestPurchaseRequestsListValue : purchaseScheduledInstancesRequestPurchaseRequestsList) {
                if (purchaseScheduledInstancesRequestPurchaseRequestsListValue.instanceCount() != null) {
                    request.addParameter("PurchaseRequest." + purchaseRequestsListIndex + ".InstanceCount", StringConversion.fromInteger((Integer)purchaseScheduledInstancesRequestPurchaseRequestsListValue.instanceCount()));
                }
                if (purchaseScheduledInstancesRequestPurchaseRequestsListValue.purchaseToken() != null) {
                    request.addParameter("PurchaseRequest." + purchaseRequestsListIndex + ".PurchaseToken", StringConversion.fromString((String)purchaseScheduledInstancesRequestPurchaseRequestsListValue.purchaseToken()));
                }
                ++purchaseRequestsListIndex;
            }
        }
        return request;
    }
}

