/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.ModifyInstancePlacementRequest;

public class ModifyInstancePlacementRequestMarshaller
implements Marshaller<Request<ModifyInstancePlacementRequest>, ModifyInstancePlacementRequest> {
    public Request<ModifyInstancePlacementRequest> marshall(ModifyInstancePlacementRequest modifyInstancePlacementRequest) {
        if (modifyInstancePlacementRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyInstancePlacementRequest, "Ec2Client");
        request.addParameter("Action", "ModifyInstancePlacement");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyInstancePlacementRequest.affinityAsString() != null) {
            request.addParameter("Affinity", StringConversion.fromString((String)modifyInstancePlacementRequest.affinityAsString()));
        }
        if (modifyInstancePlacementRequest.groupName() != null) {
            request.addParameter("GroupName", StringConversion.fromString((String)modifyInstancePlacementRequest.groupName()));
        }
        if (modifyInstancePlacementRequest.hostId() != null) {
            request.addParameter("HostId", StringConversion.fromString((String)modifyInstancePlacementRequest.hostId()));
        }
        if (modifyInstancePlacementRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringConversion.fromString((String)modifyInstancePlacementRequest.instanceId()));
        }
        if (modifyInstancePlacementRequest.tenancyAsString() != null) {
            request.addParameter("Tenancy", StringConversion.fromString((String)modifyInstancePlacementRequest.tenancyAsString()));
        }
        return request;
    }
}

