/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.ModifyIdentityIdFormatRequest;

public class ModifyIdentityIdFormatRequestMarshaller
implements Marshaller<Request<ModifyIdentityIdFormatRequest>, ModifyIdentityIdFormatRequest> {
    public Request<ModifyIdentityIdFormatRequest> marshall(ModifyIdentityIdFormatRequest modifyIdentityIdFormatRequest) {
        if (modifyIdentityIdFormatRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyIdentityIdFormatRequest, "Ec2Client");
        request.addParameter("Action", "ModifyIdentityIdFormat");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyIdentityIdFormatRequest.principalArn() != null) {
            request.addParameter("PrincipalArn", StringConversion.fromString((String)modifyIdentityIdFormatRequest.principalArn()));
        }
        if (modifyIdentityIdFormatRequest.resource() != null) {
            request.addParameter("Resource", StringConversion.fromString((String)modifyIdentityIdFormatRequest.resource()));
        }
        if (modifyIdentityIdFormatRequest.useLongIds() != null) {
            request.addParameter("UseLongIds", StringConversion.fromBoolean((Boolean)modifyIdentityIdFormatRequest.useLongIds()));
        }
        return request;
    }
}

